/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.traitextender.Extender;
import org.alfresco.traitextender.ExtensionBundle;
import org.alfresco.traitextender.ExtensionFactory;
import org.alfresco.traitextender.ExtensionPoint;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.ParameterCheck;

public class RegistryExtensionBundle
implements ExtensionBundle {
    private Map<ExtensionPoint<?, ?>, ExtensionFactory<?>> factories = new HashMap();
    private String id;

    public RegistryExtensionBundle(String id) {
        ParameterCheck.mandatory((String)"id", (Object)id);
        this.id = id;
    }

    public <E, C extends E, M extends Trait> void register(ExtensionPoint<E, M> point, ExtensionFactory<C> factory) {
        this.factories.put(point, factory);
    }

    @Override
    public void start(Extender extender) {
        Set<Map.Entry<ExtensionPoint<?, ?>, ExtensionFactory<?>>> factoryEntries = this.factories.entrySet();
        for (Map.Entry<ExtensionPoint<?, ?>, ExtensionFactory<?>> entry : factoryEntries) {
            extender.register(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void stop(Extender extender) {
        Set<Map.Entry<ExtensionPoint<?, ?>, ExtensionFactory<?>>> factoryEntries = this.factories.entrySet();
        for (Map.Entry<ExtensionPoint<?, ?>, ExtensionFactory<?>> entry : factoryEntries) {
            extender.unregister(entry.getKey());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

