/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.io.Serializable;
import org.alfresco.service.cmr.repository.NodeRef;

public class RestoreNodeReport
implements Serializable {
    private static final long serialVersionUID = 7375879981852517364L;
    private NodeRef archivedNodeRef;
    private NodeRef targetParentNodeRef;
    private NodeRef restoredNodeRef;
    private RestoreStatus status;
    private Throwable cause;

    RestoreNodeReport(NodeRef archivedNodeRef) {
        this.archivedNodeRef = archivedNodeRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("RestoreNodeReport").append("[ archived=").append(this.archivedNodeRef).append(", restored=").append(this.restoredNodeRef).append(", parent=").append(this.targetParentNodeRef).append(", status=").append((Object)this.status).append(", err=").append(this.cause == null ? "<none>" : this.cause.getMessage());
        return sb.toString();
    }

    public NodeRef getArchivedNodeRef() {
        return this.archivedNodeRef;
    }

    public NodeRef getTargetParentNodeRef() {
        return this.targetParentNodeRef;
    }

    void setTargetParentNodeRef(NodeRef targetParentNodeRef) {
        this.targetParentNodeRef = targetParentNodeRef;
    }

    public NodeRef getRestoredNodeRef() {
        return this.restoredNodeRef;
    }

    void setRestoredNodeRef(NodeRef restoredNodeRef) {
        this.restoredNodeRef = restoredNodeRef;
    }

    public RestoreStatus getStatus() {
        return this.status;
    }

    void setStatus(RestoreStatus status) {
        this.status = status;
    }

    public Throwable getCause() {
        return this.cause;
    }

    void setCause(Throwable cause) {
        this.cause = cause;
    }

    public static enum RestoreStatus {
        SUCCESS{

            @Override
            public boolean isSuccess() {
                return true;
            }
        }
        ,
        FAILURE_INVALID_ARCHIVE_NODE{}
        ,
        FAILURE_INVALID_PARENT{}
        ,
        FAILURE_PERMISSION{}
        ,
        FAILURE_INTEGRITY{}
        ,
        FAILURE_DUPLICATE_CHILD_NODE_NAME{}
        ,
        FAILURE_OTHER{};


        public boolean isSuccess() {
            return false;
        }
    }
}

