/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.dialect;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.dialect.Dialect;

public class DialectFactory {
    private static final Map<String, VersionInsensitiveMapper> MAPPERS = new HashMap<String, VersionInsensitiveMapper>();

    static {
        MAPPERS.put("PostgreSQL", new VersionInsensitiveMapper("org.alfresco.repo.domain.dialect.PostgreSQLDialect"));
        MAPPERS.put("MariaDB", new VersionInsensitiveMapper("org.alfresco.repo.domain.dialect.MySQLInnoDBDialect"));
        MAPPERS.put("MySQL", new VersionInsensitiveMapper("org.alfresco.repo.domain.dialect.MySQLInnoDBDialect"));
        MAPPERS.put("Microsoft SQL Server Database", new VersionInsensitiveMapper("org.alfresco.repo.domain.dialect.SQLServerDialect"));
        MAPPERS.put("Microsoft SQL Server", new VersionInsensitiveMapper("org.alfresco.repo.domain.dialect.SQLServerDialect"));
        MAPPERS.put("Oracle", new VersionInsensitiveMapper("org.alfresco.repo.domain.dialect.Oracle9Dialect"));
    }

    public static Dialect buildDialect(String databaseName, int databaseMajorVersion, String driverName) {
        DatabaseDialectMapper mapper;
        if (databaseName == null) {
            throw new IllegalArgumentException("Database name must be explicitly set");
        }
        DatabaseDialectMapper databaseDialectMapper = mapper = MAPPERS.get(driverName) != null ? (DatabaseDialectMapper)MAPPERS.get(driverName) : (DatabaseDialectMapper)MAPPERS.get(databaseName);
        if (mapper == null) {
            throw new IllegalArgumentException("Dialect must be explicitly set for database: " + databaseName);
        }
        String dialectName = mapper.getDialectClass(databaseMajorVersion);
        return DialectFactory.buildDialect(dialectName);
    }

    public static Dialect buildDialect(String dialectName) {
        try {
            return (Dialect)Class.forName(dialectName).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Could not instantiate dialect class", (Throwable)e);
        }
    }

    public static interface DatabaseDialectMapper {
        public String getDialectClass(int var1);
    }

    public static class VersionInsensitiveMapper
    implements DatabaseDialectMapper {
        private String dialectClassName;

        public VersionInsensitiveMapper(String dialectClassName) {
            this.dialectClassName = dialectClassName;
        }

        @Override
        public String getDialectClass(int majorVersion) {
            return this.dialectClassName;
        }
    }
}

