/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeSet;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.alfresco.ibatis.HierarchicalSqlSessionFactoryBean;
import org.alfresco.util.resource.HierarchicalResourceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class HierarchicalSqlSessionFactoryBeanTest
extends TestCase {
    private static final String QUERY_OBJECT = Object.class.getName();
    private static final String QUERY_ABSTRACTCOLLECTION = "org.alfresco.ibatis.abstractcollection." + AbstractCollection.class.getName().replace(".", "_");
    private static final String QUERY_ABSTRACTLIST = "org.alfresco.ibatis.abstractlist." + AbstractList.class.getName().replace(".", "_");
    private static final String QUERY_TREESET = "org.alfresco.ibatis.treeset." + TreeSet.class.getName().replace(".", "_");
    private static final Log LOGGER = LogFactory.getLog(HierarchicalSqlSessionFactoryBeanTest.class);
    private ClassPathXmlApplicationContext ctx;
    private TestDAO testDao;

    @Before
    public void setUp() throws Exception {
        this.testDao = new TestDAO();
        this.testDao.setId(5L);
        this.testDao.setPropOne("prop-one");
        this.testDao.setPropTwo("prop-two");
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.ctx != null) {
                this.ctx.close();
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Failed to neatly close application context", e);
        }
    }

    private Configuration getConfiguration(Class dialectClass) throws Exception {
        System.setProperty("hierarchy-test.dialect", dialectClass.getName());
        if (this.ctx != null) {
            try {
                this.ctx.close();
                this.ctx = null;
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Failed to neatly close application context", e);
            }
        }
        this.ctx = new ClassPathXmlApplicationContext("ibatis/hierarchy-test/hierarchy-test-context.xml");
        return ((SqlSessionFactory)this.ctx.getBean("mybatisConfig")).getConfiguration();
    }

    public void testContextStartup() throws Exception {
        this.getConfiguration(TreeSet.class);
        this.getConfiguration(HashSet.class);
        this.getConfiguration(ArrayList.class);
        this.getConfiguration(AbstractCollection.class);
        try {
            this.getConfiguration(Collection.class);
            HierarchicalSqlSessionFactoryBeanTest.fail((String)"Failed to detect incompatible class hierarchy");
        }
        catch (Throwable throwable) {}
    }

    public void testHierarchyTreeSet() throws Exception {
        Configuration mybatisConfig = this.getConfiguration(TreeSet.class);
        MappedStatement stmt = mybatisConfig.getMappedStatement(QUERY_TREESET);
        HierarchicalSqlSessionFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_TREESET + " using " + String.valueOf(TreeSet.class)), (Object)stmt);
        try {
            mybatisConfig.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
            HierarchicalSqlSessionFactoryBeanTest.fail((String)("Query not missing for " + QUERY_ABSTRACTCOLLECTION + " using " + String.valueOf(TreeSet.class)));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testHierarchyHashSet() throws Exception {
        Configuration mybatisConfig = this.getConfiguration(HashSet.class);
        MappedStatement stmt = mybatisConfig.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
        HierarchicalSqlSessionFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_ABSTRACTCOLLECTION + " using " + String.valueOf(HashSet.class)), (Object)stmt);
        try {
            mybatisConfig.getMappedStatement(QUERY_OBJECT);
            HierarchicalSqlSessionFactoryBeanTest.fail((String)("Query not missing for " + QUERY_OBJECT + " using " + String.valueOf(HashSet.class)));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testHierarchyArrayList() throws Exception {
        Configuration mybatisConfig = this.getConfiguration(ArrayList.class);
        MappedStatement stmt = mybatisConfig.getMappedStatement(QUERY_ABSTRACTLIST);
        HierarchicalSqlSessionFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_ABSTRACTLIST + " using " + String.valueOf(ArrayList.class)), (Object)stmt);
        try {
            mybatisConfig.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
            HierarchicalSqlSessionFactoryBeanTest.fail((String)("Query not missing for " + QUERY_ABSTRACTCOLLECTION + " using " + String.valueOf(ArrayList.class)));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testHierarchyAbstractCollection() throws Exception {
        Configuration mybatisConfig = this.getConfiguration(AbstractCollection.class);
        MappedStatement stmt = mybatisConfig.getMappedStatement(QUERY_ABSTRACTCOLLECTION);
        HierarchicalSqlSessionFactoryBeanTest.assertNotNull((String)("Query missing for " + QUERY_ABSTRACTCOLLECTION + " using " + String.valueOf(AbstractCollection.class)), (Object)stmt);
        try {
            mybatisConfig.getMappedStatement(QUERY_OBJECT);
            HierarchicalSqlSessionFactoryBeanTest.fail((String)("Query not missing for " + QUERY_OBJECT + " using " + String.valueOf(AbstractCollection.class)));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testConfigureFetchSizeForMariaDBDriver() throws Exception {
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData mockMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        HierarchicalResourceLoader mockResourceLoader = (HierarchicalResourceLoader)Mockito.mock(HierarchicalResourceLoader.class);
        Mockito.when((Object)mockDataSource.getConnection()).thenReturn((Object)mockConnection);
        Mockito.when((Object)mockConnection.getMetaData()).thenReturn((Object)mockMetaData);
        Mockito.when((Object)mockMetaData.getDriverName()).thenReturn((Object)"MariaDB Connector/J");
        HierarchicalSqlSessionFactoryBean bean = new HierarchicalSqlSessionFactoryBean();
        bean.setDataSource(mockDataSource);
        bean.setResourceLoader(mockResourceLoader);
        bean.afterPropertiesSet();
        Properties props = bean.getObject().getConfiguration().getVariables();
        HierarchicalSqlSessionFactoryBeanTest.assertNotNull((Object)props);
        HierarchicalSqlSessionFactoryBeanTest.assertEquals((String)"Fetch size for MariaDB driver should be 1", (String)"1", (String)props.getProperty("db.fetchsize"));
    }

    @Test
    public void testConfigureFetchSizeForMySQLDriver() throws Exception {
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData mockMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        HierarchicalResourceLoader mockResourceLoader = (HierarchicalResourceLoader)Mockito.mock(HierarchicalResourceLoader.class);
        Mockito.when((Object)mockDataSource.getConnection()).thenReturn((Object)mockConnection);
        Mockito.when((Object)mockConnection.getMetaData()).thenReturn((Object)mockMetaData);
        Mockito.when((Object)mockMetaData.getDriverName()).thenReturn((Object)"MySQL Connector/J");
        HierarchicalSqlSessionFactoryBean bean = new HierarchicalSqlSessionFactoryBean();
        bean.setDataSource(mockDataSource);
        bean.setResourceLoader(mockResourceLoader);
        bean.afterPropertiesSet();
        Properties props = bean.getObject().getConfiguration().getVariables();
        HierarchicalSqlSessionFactoryBeanTest.assertNotNull((Object)props);
        HierarchicalSqlSessionFactoryBeanTest.assertEquals((String)"Fetch size for MySQL driver should be Integer.MIN_VALUE", (String)String.valueOf(Integer.MIN_VALUE), (String)props.getProperty("db.fetchsize"));
    }

    public static class TestDAO {
        private Long id;
        private String propOne;
        private String propTwo;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getPropOne() {
            return this.propOne;
        }

        public void setPropOne(String propOne) {
            this.propOne = propOne;
        }

        public String getPropTwo() {
            return this.propTwo;
        }

        public void setPropTwo(String propTwo) {
            this.propTwo = propTwo;
        }
    }
}

