/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AlfrescoSSLSocketFactory;
import org.alfresco.repo.security.authentication.AuthenticationDiagnostic;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

public class LDAPInitialDirContextFactoryImpl
implements LDAPInitialDirContextFactory,
InitializingBean {
    private static final Log logger = LogFactory.getLog(LDAPInitialDirContextFactoryImpl.class);
    private SimpleCache<String, Set<Map<String, String>>> ldapInitialDirContextCache;
    private Map<String, String> defaultEnvironment = Collections.emptyMap();
    private Map<String, String> authenticatedEnvironment = Collections.emptyMap();
    private Map<String, String> poolSystemProperties = Collections.emptyMap();
    private String trustStorePath;
    private String trustStoreType;
    private String trustStorePassPhrase;
    private boolean initialChecksEnabled = true;
    private final String ANONYMOUS_CHECK = "anonymous_check";
    private final String SIMPLE_DN_CHECK = "simple_dn_check";
    private final String DN_CHECK = "dn_check";
    private final String PRINCIPAL_CHECK = "principal_check";

    static {
        System.setProperty("javax.security.auth.useSubjectCredentialsOnly", "false");
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        if (PropertyCheck.isValidPropertyString((String)trustStorePath)) {
            this.trustStorePath = trustStorePath;
        }
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        if (PropertyCheck.isValidPropertyString((String)trustStoreType)) {
            this.trustStoreType = trustStoreType;
        }
    }

    public String getTrustStorePassPhrase() {
        return this.trustStorePassPhrase;
    }

    public void setTrustStorePassPhrase(String trustStorePassPhrase) {
        if (PropertyCheck.isValidPropertyString((String)trustStorePassPhrase)) {
            this.trustStorePassPhrase = trustStorePassPhrase;
        }
    }

    @Override
    public void setInitialDirContextEnvironment(Map<String, String> initialDirContextEnvironment) {
        this.authenticatedEnvironment = initialDirContextEnvironment;
        this.authenticatedEnvironment.values().removeAll(Collections.singleton(null));
    }

    public Map<String, String> getInitialDirContextEnvironment() {
        return this.authenticatedEnvironment;
    }

    public void setDefaultIntialDirContextEnvironment(Map<String, String> defaultEnvironment) {
        this.defaultEnvironment = new LinkedHashMap<String, String>(defaultEnvironment.size());
        this.defaultEnvironment.putAll(defaultEnvironment);
        for (Map.Entry<String, String> entry : defaultEnvironment.entrySet()) {
            if (entry.getValue() != null && entry.getValue().trim().length() != 0) continue;
            this.defaultEnvironment.remove(entry.getKey());
        }
        this.defaultEnvironment.values().removeAll(Collections.singleton(null));
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext() throws AuthenticationException {
        return this.getDefaultIntialDirContext(0, new AuthenticationDiagnostic());
    }

    public void setPoolSystemProperties(Map<String, String> poolSystemProperties) {
        this.poolSystemProperties = poolSystemProperties;
        for (Map.Entry<String, String> entry : this.poolSystemProperties.entrySet()) {
            if (entry.getValue() == null || entry.getValue().trim().length() <= 0) continue;
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(int pageSize) throws AuthenticationException {
        return this.getDefaultIntialDirContext(pageSize, new AuthenticationDiagnostic());
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        return this.getDefaultIntialDirContext(0, diagnostic);
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(int pageSize, AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>(this.defaultEnvironment.size());
        env.putAll(this.defaultEnvironment);
        return this.buildInitialDirContext(env, pageSize, diagnostic);
    }

    /*
     * Unable to fully structure code
     */
    private InitialDirContext buildInitialDirContext(Hashtable<String, String> env, int pageSize, AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        securityPrincipal = env.get("java.naming.security.principal");
        providerURL = env.get("java.naming.provider.url");
        if (this.isSSLSocketFactoryRequired()) {
            trustStore = this.initTrustStore();
            AlfrescoSSLSocketFactory.initTrustedSSLSocketFactory(trustStore);
            env.put("java.naming.ldap.factory.socket", AlfrescoSSLSocketFactory.class.getName());
        }
        if (diagnostic == null) {
            diagnostic = new AuthenticationDiagnostic();
        }
        try {
            if (pageSize > 0) {
                ctx = new InitialLdapContext(env, null);
                ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
                return ctx;
            }
            ret = new InitialDirContext(env);
            args = new Object[]{providerURL, securityPrincipal};
            diagnostic.addStep("authentication.step.ldap.connected", true, args);
            return ret;
        }
        catch (javax.naming.AuthenticationException ax) {
            args1 = new Object[]{securityPrincipal};
            args = new Object[]{providerURL, securityPrincipal};
            diagnostic.addStep("authentication.step.ldap.connected", true, args);
            diagnostic.addStep("authentication.step.ldap.authentication", false, args1);
            args2 = new Object[]{securityPrincipal, ax.getLocalizedMessage()};
            throw new AuthenticationException("authentication.err.authentication", diagnostic, args2, (Throwable)ax);
        }
        catch (CommunicationException ce) {
            args1 = new Object[]{providerURL};
            diagnostic.addStep("authentication.step.ldap.connecting", false, args1);
            message = new StringBuffer();
            message.append(ce.getClass().getName() + ", " + ce.getMessage());
            cause = ce.getCause();
            ** while (cause != null)
        }
lbl-1000:
        // 1 sources

        {
            message.append(", ");
            message.append(cause.getClass().getName() + ", " + cause.getMessage());
            cause = cause.getCause();
            continue;
        }
lbl40:
        // 1 sources

        args = new Object[]{providerURL, message.toString()};
        throw new AuthenticationException("authentication.err.communication", diagnostic, args, cause);
        catch (NamingException nx) {
            args = new Object[]{providerURL};
            diagnostic.addStep("authentication.step.ldap.connecting", false, args);
            message = new StringBuffer();
            message.append(nx.getClass().getName() + ", " + nx.getMessage());
            cause = nx.getCause();
            ** while (cause != null)
        }
lbl-1000:
        // 1 sources

        {
            message.append(", ");
            message.append(cause.getClass().getName() + ", " + cause.getMessage());
            cause = cause.getCause();
            continue;
        }
lbl56:
        // 1 sources

        args1 = new Object[]{providerURL, message.toString()};
        throw new AuthenticationException("authentication.err.connection", diagnostic, args1, (Throwable)nx);
        catch (IOException e) {
            args = new Object[]{providerURL, securityPrincipal};
            diagnostic.addStep("authentication.step.ldap.connected", true, args);
            throw new AuthenticationException("Unable to encode LDAP v3 request controls", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNextPage(DirContext ctx, int pageSize) {
        if (pageSize <= 0) return false;
        try {
            LdapContext ldapContext = (LdapContext)ctx;
            Control[] controls = ldapContext.getResponseControls();
            if (controls == null) return false;
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (true) {
                byte[] cookie;
                if (n2 >= n) {
                    return false;
                }
                Control control = controlArray[n2];
                if (control instanceof PagedResultsResponseControl && (cookie = ((PagedResultsResponseControl)control).getCookie()) != null) {
                    ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
                    return true;
                }
                ++n2;
            }
        }
        catch (NamingException nx) {
            throw new AuthenticationException("Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
        }
        catch (IOException e) {
            throw new AuthenticationException("Unable to encode LDAP v3 request controls; check LDAP configuration", (Throwable)e);
        }
    }

    @Override
    public InitialDirContext getInitialDirContext(String principal, String credentials) throws AuthenticationException {
        return this.getInitialDirContext(principal, credentials, null);
    }

    @Override
    public InitialDirContext getInitialDirContext(String principal, String credentials, AuthenticationDiagnostic diagnostic) throws AuthenticationException {
        if (diagnostic == null) {
            diagnostic = new AuthenticationDiagnostic();
        }
        if (principal == null) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("Null user name provided.", diagnostic);
        }
        if (principal.length() == 0) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("Empty user name provided.", diagnostic);
        }
        if (credentials == null) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("No credentials provided.", diagnostic);
        }
        if (credentials.length() == 0) {
            diagnostic.addStep("authentication.step.ldap.validation", false, null);
            throw new AuthenticationException("Empty credentials provided.", diagnostic);
        }
        diagnostic.addStep("authentication.step.ldap.validation", true, null);
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", credentials);
        return this.buildInitialDirContext(env, 0, diagnostic);
    }

    public static void main(String[] args) {
        block15: {
            int userMembers = Integer.parseInt(args[3]);
            ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
            LDAPInitialDirContextFactory factory = (LDAPInitialDirContextFactory)applicationContext.getBean("ldapInitialDirContextFactory");
            InitialContext ctx = null;
            try {
                try {
                    ctx = factory.getInitialDirContext("cn=" + args[0] + "," + args[2], args[1]);
                    BasicAttribute objClasses = new BasicAttribute("objectclass");
                    objClasses.add("top");
                    objClasses.add("person");
                    objClasses.add("organizationalPerson");
                    objClasses.add("inetOrgPerson");
                    int i = 0;
                    while (i < userMembers) {
                        BasicAttribute cn = new BasicAttribute("cn", "User" + i + " TestUser");
                        BasicAttribute sn = new BasicAttribute("sn", "TestUser");
                        BasicAttribute givenNames = new BasicAttribute("givenName", "User" + i);
                        BasicAttribute telephoneNumber = new BasicAttribute("telephoneNumber", "123");
                        BasicAttribute uid = new BasicAttribute("uid", "User" + i);
                        BasicAttribute mail = new BasicAttribute("mail", "woof@woof");
                        BasicAttribute o = new BasicAttribute("o", "Alfresco");
                        BasicAttribute userPassword = new BasicAttribute("userPassword", "bobbins");
                        String dn = "cn=User" + i + " TestUser," + args[2];
                        BasicAttributes orig = new BasicAttributes();
                        orig.put(objClasses);
                        orig.put(cn);
                        orig.put(sn);
                        orig.put(givenNames);
                        orig.put(telephoneNumber);
                        orig.put(uid);
                        orig.put(mail);
                        orig.put(o);
                        orig.put(userPassword);
                        try {
                            ctx.destroySubcontext(dn);
                        }
                        catch (NamingException e) {
                            e.printStackTrace();
                        }
                        ((InitialDirContext)ctx).createSubcontext(dn, orig);
                        ++i;
                    }
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    if (ctx == null) break block15;
                    try {
                        ctx.close();
                    }
                    catch (NamingException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        logger.debug((Object)"after Properties Set");
        if (this.initialChecksEnabled) {
            this.checkAnonymousBind();
            this.checkSimpleDnAndPassword();
            this.checkDnAndPassword();
            this.checkPrincipal();
        } else {
            logger.info((Object)"LDAP checks are disabled");
        }
    }

    private void checkAnonymousBind() {
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.remove("java.naming.security.principal");
        env.remove("java.naming.security.credentials");
        if (this.isSSLSocketFactoryRequired()) {
            KeyStore trustStore = this.initTrustStore();
            AlfrescoSSLSocketFactory.initTrustedSSLSocketFactory(trustStore);
            env.put("java.naming.ldap.factory.socket", AlfrescoSSLSocketFactory.class.getName());
        }
        if (!this.isCached("anonymous_check", env)) {
            logger.debug((Object)"Starting check: Anonymous bind");
            try {
                new InitialDirContext(env);
                logger.warn((Object)("LDAP server supports anonymous bind " + env.get("java.naming.provider.url")));
            }
            catch (javax.naming.AuthenticationException | AuthenticationNotSupportedException namingSecurityException) {
            }
            catch (NamingException nx) {
                logger.error((Object)"Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
            }
            this.addToCache("anonymous_check", env);
        }
    }

    private void checkSimpleDnAndPassword() {
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", "daftAsABrush");
        env.put("java.naming.security.credentials", "daftAsABrush");
        if (this.isSSLSocketFactoryRequired()) {
            KeyStore trustStore = this.initTrustStore();
            AlfrescoSSLSocketFactory.initTrustedSSLSocketFactory(trustStore);
            env.put("java.naming.ldap.factory.socket", AlfrescoSSLSocketFactory.class.getName());
        }
        if (!this.isCached("simple_dn_check", env)) {
            logger.debug((Object)"Starting check: Simple DN and Password");
            try {
                new InitialDirContext(env);
                throw new AuthenticationException("The ldap server at " + env.get("java.naming.provider.url") + " falls back to use anonymous bind if invalid security credentials are presented. This is not supported.");
            }
            catch (javax.naming.AuthenticationException | AuthenticationNotSupportedException namingSecurityException) {
                logger.info((Object)("LDAP server does not fall back to anonymous bind for a string uid and password at " + env.get("java.naming.provider.url")));
            }
            catch (NamingException namingException) {
                logger.info((Object)("LDAP server does not support simple string user ids and invalid credentials at " + env.get("java.naming.provider.url")));
            }
            this.addToCache("simple_dn_check", env);
        }
    }

    private void checkDnAndPassword() {
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", "cn=daftAsABrush,dc=woof");
        env.put("java.naming.security.credentials", "daftAsABrush");
        if (this.isSSLSocketFactoryRequired()) {
            KeyStore trustStore = this.initTrustStore();
            AlfrescoSSLSocketFactory.initTrustedSSLSocketFactory(trustStore);
            env.put("java.naming.ldap.factory.socket", AlfrescoSSLSocketFactory.class.getName());
        }
        if (!this.isCached("dn_check", env)) {
            logger.debug((Object)"Starting check: DN and Password");
            try {
                new InitialDirContext(env);
                throw new AuthenticationException("The ldap server at " + env.get("java.naming.provider.url") + " falls back to use anonymous bind if invalid security credentials are presented. This is not supported.");
            }
            catch (javax.naming.AuthenticationException | AuthenticationNotSupportedException namingSecurityException) {
                logger.info((Object)("LDAP server does not fall back to anonymous bind for a simple dn and password at " + env.get("java.naming.provider.url")));
            }
            catch (NamingException namingException) {
                logger.info((Object)("LDAP server does not support simple DN and invalid password at " + env.get("java.naming.provider.url")));
            }
            this.addToCache("dn_check", env);
        }
    }

    private void checkPrincipal() {
        String principal = this.defaultEnvironment.get("java.naming.security.principal");
        if (principal != null) {
            Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
            env.putAll(this.authenticatedEnvironment);
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", "sdasdasdasdasd123123123");
            if (this.isSSLSocketFactoryRequired()) {
                KeyStore trustStore = this.initTrustStore();
                AlfrescoSSLSocketFactory.initTrustedSSLSocketFactory(trustStore);
                env.put("java.naming.ldap.factory.socket", AlfrescoSSLSocketFactory.class.getName());
            }
            if (!this.isCached("principal_check", env)) {
                logger.debug((Object)"Starting check: Principal");
                try {
                    new InitialDirContext(env);
                    throw new AuthenticationException("The ldap server at " + env.get("java.naming.provider.url") + " falls back to use anonymous bind for a known principal if  invalid security credentials are presented. This is not supported.");
                }
                catch (javax.naming.AuthenticationException authenticationException) {
                    logger.info((Object)("LDAP server does not fall back to anonymous bind for known principal and invalid credentials at " + env.get("java.naming.provider.url")));
                }
                catch (AuthenticationNotSupportedException authenticationNotSupportedException) {
                    logger.info((Object)"LDAP server does not support the required authentication mechanism");
                }
                catch (NamingException namingException) {}
                this.addToCache("principal_check", env);
            }
        }
    }

    private boolean isSSLSocketFactoryRequired() {
        boolean result = false;
        String protocol = this.authenticatedEnvironment.get("java.naming.security.protocol");
        if (protocol != null && protocol.equals("ssl")) {
            if (this.getTrustStoreType() != null && this.getTrustStorePath() != null && this.getTrustStoreType() != null) {
                result = true;
            } else {
                logger.warn((Object)"The SSL configuration for LDAPS is not full, the default configuration will be used.");
            }
        }
        return result;
    }

    private KeyStore initTrustStore() {
        KeyStore ks;
        String trustStoreType = this.getTrustStoreType();
        try {
            ks = KeyStore.getInstance(trustStoreType);
        }
        catch (KeyStoreException kse) {
            throw new AlfrescoRuntimeException("No provider supports " + trustStoreType, (Throwable)kse);
        }
        try {
            ks.load(new FileInputStream(this.getTrustStorePath()), this.getTrustStorePassPhrase().toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            throw new AlfrescoRuntimeException("The truststore file is not found.", (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new AlfrescoRuntimeException("The truststore file cannot be read.", (Throwable)ioe);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AlfrescoRuntimeException("Algorithm used to check the integrity of the truststore cannot be found.", (Throwable)nsae);
        }
        catch (CertificateException ce) {
            throw new AlfrescoRuntimeException("The certificates cannot be loaded from truststore.", (Throwable)ce);
        }
        return ks;
    }

    private void addToCache(String key, Map<String, String> value) {
        Set<Map<String, String>> envs = (Set<Map<String, String>>)this.ldapInitialDirContextCache.get((Serializable)((Object)key));
        if (envs == null) {
            envs = Collections.synchronizedSet(new HashSet(11));
        }
        if (!envs.contains(value)) {
            envs.add(value);
        }
        if (!this.ldapInitialDirContextCache.contains((Serializable)((Object)key))) {
            this.ldapInitialDirContextCache.put((Serializable)((Object)key), envs);
        }
    }

    private void removeFromCache(String key, Map<String, String> value) {
        Set envs;
        if (this.ldapInitialDirContextCache != null && this.ldapInitialDirContextCache.contains((Serializable)((Object)key)) && (envs = (Set)this.ldapInitialDirContextCache.get((Serializable)((Object)key))) != null && envs.contains(value)) {
            envs.remove(value);
            if (envs.isEmpty()) {
                this.ldapInitialDirContextCache.remove((Serializable)((Object)key));
            }
        }
    }

    private boolean isCached(String key, Map<String, String> value) {
        Set envs;
        boolean isCached = false;
        if (this.ldapInitialDirContextCache != null && this.ldapInitialDirContextCache.contains((Serializable)((Object)key)) && (envs = (Set)this.ldapInitialDirContextCache.get((Serializable)((Object)key))) != null && envs.contains(value)) {
            isCached = true;
        }
        logger.debug((Object)("LDAP check: " + key + " / isCached: " + (isCached ? "yes" : "no")));
        return isCached;
    }

    public void setLdapInitialDirContextCache(SimpleCache<String, Set<Map<String, String>>> cache) {
        this.ldapInitialDirContextCache = cache;
    }

    public void setInitialChecksEnabled(boolean initialChecksEnabled) {
        this.initialChecksEnabled = initialChecksEnabled;
    }
}

