/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DynamicCreateRepositoryLocation
extends RepositoryLocation {
    private static final Log logger = LogFactory.getLog(DynamicCreateRepositoryLocation.class);
    private ImporterService importerService;
    private String contentViewLocation;
    private ResourceBundle bundle;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private TransactionService transactionService;

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setContentViewLocation(String contentViewLocation) {
        this.contentViewLocation = contentViewLocation;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setBundleName(String bundleName) {
        Locale bindingLocale = I18NUtil.getLocale();
        this.bundle = ResourceBundle.getBundle(bundleName, bindingLocale);
    }

    public void checkAndCreate(NodeRef rootNodeRef) {
        List nodes = this.searchService.selectNodes(rootNodeRef, this.getPath(), null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodes.size() == 0) {
            logger.info((Object)("Repository location " + this.getPath() + " does not exist for tenant " + TenantUtil.getCurrentDomain() + ", creating"));
            this.create();
        }
    }

    protected String getParentPath() {
        String parentPath = null;
        String path = this.getPath();
        int idx = path.lastIndexOf("/");
        parentPath = idx != -1 ? path.substring(0, idx) : "/";
        return parentPath;
    }

    protected void create() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> initCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                DynamicCreateRepositoryLocation.this.onCreateInTxn();
                return null;
            }
        };
        this.getTransactionService().getRetryingTransactionHelper().doInTransaction(initCallback, false, true);
    }

    private void onCreateInTxn() {
        File viewFile = ImporterBootstrap.getFile(this.contentViewLocation);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(viewFile, null);
        Location location = new Location(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        location.setPath(this.getParentPath());
        ImporterBinding binding = new ImporterBinding(){

            @Override
            public String getValue(String key) {
                return DynamicCreateRepositoryLocation.this.bundle.getString(key);
            }

            @Override
            public ImporterBinding.UUID_BINDING getUUIDBinding() {
                return ImporterBinding.UUID_BINDING.CREATE_NEW;
            }

            @Override
            public QName[] getExcludedClasses() {
                return null;
            }

            @Override
            public boolean allowReferenceWithinTransaction() {
                return false;
            }

            @Override
            public ImporterContentCache getImportConentCache() {
                return null;
            }
        };
        this.importerService.importView(acpHandler, location, binding, null);
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

