/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.EditionService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class AbstractMultilingualTestCases
extends TestCase {
    protected static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected ServiceRegistry serviceRegistry;
    protected AuthenticationComponent authenticationComponent;
    protected TransactionService transactionService;
    protected NodeService nodeService;
    protected FileFolderService fileFolderService;
    protected VersionService versionService;
    protected MultilingualContentService multilingualContentService;
    protected NodeRef folderNodeRef;
    protected ContentFilterLanguagesService contentFilterLanguagesService;
    protected NodeArchiveService nodeArchiveService;
    protected EditionService editionService;

    protected void setUp() throws Exception {
        this.nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("AuthenticationComponent");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.versionService = this.serviceRegistry.getVersionService();
        this.multilingualContentService = (MultilingualContentService)ctx.getBean("MultilingualContentService");
        this.contentFilterLanguagesService = (ContentFilterLanguagesService)ctx.getBean("ContentFilterLanguagesService");
        this.editionService = (EditionService)ctx.getBean("EditionService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createFolderCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Exception {
                StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
                NodeRef rootNodeRef = AbstractMultilingualTestCases.this.nodeService.getRootNode(storeRef);
                NodeRef folderNodeRef = AbstractMultilingualTestCases.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
                return folderNodeRef;
            }
        };
        this.folderNodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createFolderCallback);
    }

    protected void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected NodeRef createContent() {
        String name = "" + System.currentTimeMillis();
        return this.createContent(name);
    }

    protected NodeRef createContent(String name) {
        NodeRef contentNodeRef = this.fileFolderService.create(this.folderNodeRef, name, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter contentWriter = this.fileFolderService.getWriter(contentNodeRef);
        contentWriter.putContent("ABC");
        return contentNodeRef;
    }

    public void testSetup() throws Exception {
        this.createContent();
    }
}

