/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.quota;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.cleanup.CachedContentCleaner;
import org.alfresco.repo.content.caching.quota.StandardQuotaStrategy;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class StandardQuotaStrategyTest {
    private static ApplicationContext ctx;
    private CachingContentStore store;
    private static byte[] aKB;
    private ContentCacheImpl cache;
    private File cacheRoot;
    private StandardQuotaStrategy quota;
    private CachedContentCleaner cleaner;

    @BeforeClass
    public static void beforeClass() {
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:cachingstore/test-std-quota-context.xml"});
        aKB = new byte[1024];
        Arrays.fill(aKB, (byte)36);
    }

    @AfterClass
    public static void afterClass() {
        ApplicationContextHelper.closeApplicationContext();
    }

    @Before
    public void setUp() throws Exception {
        this.store = (CachingContentStore)ctx.getBean("cachingContentStore");
        this.store.setCacheOnInbound(true);
        this.cache = (ContentCacheImpl)ctx.getBean("contentCache");
        this.cacheRoot = this.cache.getCacheRoot();
        this.quota = (StandardQuotaStrategy)ctx.getBean("quotaManager");
        this.quota.setCurrentUsageBytes(0L);
        this.quota.setMaxFileSizeMB(0);
        this.cleaner = (CachedContentCleaner)ctx.getBean("cachedContentCleaner");
        this.cache.removeAll();
        FileUtils.cleanDirectory((File)this.cacheRoot);
    }

    @Test
    public void cleanerWillTriggerAtCorrectThreshold() throws IOException, InterruptedException {
        ArrayList<String> contentURLs = new ArrayList<String>();
        int i = 0;
        while (i < 15) {
            String url = this.writeSingleFileInMB(1);
            contentURLs.add(url);
            ++i;
        }
        Assert.assertEquals((long)15L, (long)this.findCacheFiles().size());
        int evictCount = 0;
        while (evictCount < 10) {
            this.cache.remove((String)contentURLs.get(evictCount));
            ++evictCount;
        }
        this.writeSingleFileInMB(1);
        Thread.sleep(200L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(50L);
        }
        Assert.assertEquals((long)6L, (long)this.findCacheFiles().size());
    }

    @Test
    public void cachingIsDisabledAtCorrectThreshold() throws IOException {
        int i = 0;
        while (i < 4) {
            this.writeSingleFileInMB(6);
            ++i;
        }
        Assert.assertEquals((long)3L, (long)this.findCacheFiles().size());
    }

    @Test
    public void largeContentCacheFilesAreNotKeptOnDisk() throws IOException {
        this.quota.setMaxFileSizeMB(3);
        this.writeSingleFileInMB(1);
        this.writeSingleFileInMB(2);
        this.writeSingleFileInMB(3);
        this.writeSingleFileInMB(4);
        ArrayList<File> files = new ArrayList<File>(this.findCacheFiles());
        Assert.assertEquals((long)3L, (long)files.size());
        Collections.sort(files, SizeFileComparator.SIZE_COMPARATOR);
        Assert.assertEquals((long)1L, (long)(((File)files.get(0)).length() / 0x100000L));
        Assert.assertEquals((long)2L, (long)(((File)files.get(1)).length() / 0x100000L));
        Assert.assertEquals((long)3L, (long)(((File)files.get(2)).length() / 0x100000L));
    }

    private String writeSingleFileInMB(int sizeInMb) throws IOException {
        ContentWriter writer = this.store.getWriter(ContentContext.NULL_CONTEXT);
        File content = this.createFileOfSize(sizeInMb * 1024);
        writer.putContent(content);
        return writer.getContentUrl();
    }

    private File createFileOfSize(long sizeInKB) throws IOException {
        File file = new File(TempFileProvider.getSystemTempDir(), GUID.generate() + ".generated");
        file.deleteOnExit();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        long i = 0L;
        while (i < sizeInKB) {
            os.write(aKB);
            ++i;
        }
        os.close();
        return file;
    }

    private Collection<File> findCacheFiles() {
        return FileUtils.listFiles((File)this.cacheRoot, (IOFileFilter)new SuffixFileFilter(".bin"), (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    private void concurrencySmokeTest() throws Exception {
        StandardQuotaStrategyTest.beforeClass();
        this.setUp();
        this.cleaner.setMaxDeleteWatchCount(Integer.valueOf(1));
        Thread[] writers = new Thread[100];
        int i = 0;
        while (i < 100) {
            final String threadName = "WriterThread[" + i + "]";
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        this.writeFile();
                        this.pause();
                    }
                }

                private void writeFile() {
                    try {
                        StandardQuotaStrategyTest.this.writeSingleFileInMB(1);
                    }
                    catch (IOException error) {
                        throw new RuntimeException(threadName + " couldn't write file.", error);
                    }
                }

                private void pause() {
                    long pauseTimeMillis = Math.round(Math.random() * 2000.0);
                    try {
                        Thread.sleep(pauseTimeMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(threadName + " InterruptedException.");
                    }
                }
            };
            Thread writerThread = new Thread(runnable);
            writerThread.setName(threadName);
            writers[i] = writerThread;
            writerThread.start();
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        StandardQuotaStrategyTest test = new StandardQuotaStrategyTest();
        test.concurrencySmokeTest();
    }
}

