/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.listener;

import java.util.Calendar;
import java.util.Date;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.alfresco.util.ISO8601DateFormat;

public class ConvertDateToISO8601
implements ExecutionListener {
    protected Expression source;
    protected Expression target;

    public void setSource(Expression source) {
        this.source = source;
    }

    public void setTarget(Expression target) {
        this.target = target;
    }

    public void notify(DelegateExecution execution) throws Exception {
        String sourceVarName = this.getExpressionString(this.source, (VariableScope)execution);
        String targetVarName = this.getExpressionString(this.target, (VariableScope)execution);
        if (sourceVarName == null || targetVarName == null) {
            throw new IllegalArgumentException("Both fields 'source' and 'target' shoudl be set");
        }
        Object dateVar = execution.getVariable(sourceVarName);
        Date dateToConvert = null;
        if (dateVar != null) {
            if (dateVar instanceof Date) {
                dateToConvert = (Date)execution.getVariable(sourceVarName);
            } else if (dateVar instanceof Calendar) {
                dateToConvert = ((Calendar)execution.getVariable(sourceVarName)).getTime();
            } else {
                throw new IllegalArgumentException("Variable with name: " + sourceVarName + " must be a Date or a Calendar");
            }
        }
        if (dateToConvert != null) {
            String convertedDate = ISO8601DateFormat.format(dateToConvert);
            execution.setVariable(targetVarName, (Object)convertedDate);
        }
    }

    protected String getExpressionString(Expression expression, VariableScope variableScope) {
        if (expression != null) {
            return (String)expression.getValue(variableScope);
        }
        return null;
    }
}

