/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.text.MessageFormat;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.app.JSONConversionComponent;
import org.springframework.extensions.surf.util.URLEncoder;

public final class ApplicationScriptUtils
extends BaseScopableProcessorExtension {
    private static final String CONTENT_DOWNLOAD_API_URL = "/api/node/content/{0}/{1}/{2}/{3}";
    private JSONConversionComponent jsonConversionComponent;

    public void setJsonConversionComponent(JSONConversionComponent jsonConversionComponent) {
        this.jsonConversionComponent = jsonConversionComponent;
    }

    public String toJSON(ScriptNode node) {
        return this.toJSON(node, false);
    }

    public String toJSON(ScriptNode node, boolean useShortQNames) {
        return this.jsonConversionComponent.toJSON(node.getNodeRef(), useShortQNames);
    }

    public String getDownloadAPIUrl(ScriptNode node) {
        if (node.getIsDocument()) {
            return MessageFormat.format(CONTENT_DOWNLOAD_API_URL, node.nodeRef.getStoreRef().getProtocol(), node.nodeRef.getStoreRef().getIdentifier(), node.nodeRef.getId(), URLEncoder.encode((String)node.getName()));
        }
        return "";
    }
}

