/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.action.AbstractAsynchronousActionFilter;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.ActionServiceImpl;
import org.alfresco.repo.action.AsynchronousActionExecutionQueue;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.action.OngoingAsyncAction;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rule.RuleServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsynchronousActionExecutionQueueImpl
implements AsynchronousActionExecutionQueue {
    private static Log logger = LogFactory.getLog(AsynchronousActionExecutionQueueImpl.class);
    private ActionServiceImpl actionServiceImpl;
    private ThreadPoolExecutor threadPoolExecutor;
    private TransactionService transactionService;
    private PolicyComponent policyComponent;
    private Map<String, AbstractAsynchronousActionFilter> actionFilters = new ConcurrentHashMap<String, AbstractAsynchronousActionFilter>();
    private String id;
    List<OngoingAsyncAction> ongoingActions = new Vector<OngoingAsyncAction>();
    private ClassPolicyDelegate<AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute> onAsyncActionExecuteDelegate;

    public void init() {
        this.actionServiceImpl.registerAsynchronousActionExecutionQueue(this.id, this);
        this.onAsyncActionExecuteDelegate = this.policyComponent.registerClassPolicy(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.class);
    }

    public void setActionServiceImpl(ActionServiceImpl serviceImpl) {
        this.actionServiceImpl = serviceImpl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        logger.warn((Object)"Property 'authenticationContext' is no longer required.");
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    private void invokeOnAsyncActionExecutePolicy(Action action, NodeRef actionedUponNodeRef) {
        AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute policy = this.onAsyncActionExecuteDelegate.get(actionedUponNodeRef, ActionModel.TYPE_ACTION);
        policy.onAsyncActionExecute(action, actionedUponNodeRef);
    }

    public void registerActionFilter(AbstractAsynchronousActionFilter filter) {
        String filterName = filter.getName();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Registered asynchronous action filter ").append(filter.getName()).append(" for action ").append(filter.getActionDefinitionName());
            logger.debug((Object)msg.toString());
        }
        AbstractAsynchronousActionFilter existingFilter = this.actionFilters.get(filterName);
        if (logger.isDebugEnabled() && existingFilter != null) {
            StringBuilder msg = new StringBuilder();
            msg.append("This replaces previous filter ").append(existingFilter.getName());
            logger.debug((Object)msg.toString());
        }
        this.actionFilters.put(filter.getName(), filter);
    }

    @Override
    public void executeAction(RuntimeActionService actionService, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain) {
        this.executeAction(actionService, action, actionedUponNodeRef, checkConditions, actionChain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(RuntimeActionService actionService, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain, NodeRef actionExecutionHistoryNodeRef) {
        StringBuilder msg;
        if (logger.isDebugEnabled()) {
            StringBuilder msg2 = new StringBuilder();
            msg2.append("Received request to execute async action ").append(action.getActionDefinitionName()).append(" on ").append(actionedUponNodeRef);
            logger.debug((Object)msg2.toString());
            msg2 = new StringBuilder();
            msg2.append("ThreadPool's active count = ").append(this.threadPoolExecutor.getActiveCount());
            logger.debug((Object)msg2.toString());
            msg2 = new StringBuilder();
            msg2.append("ThreadPool's queue size = ").append(this.threadPoolExecutor.getQueue().size());
            logger.debug((Object)msg2.toString());
        }
        Set executedRules = (Set)AlfrescoTransactionSupport.getResource((Object)"RuleServiceImpl.ExecutedRules");
        ActionExecutionWrapper runnable = new ActionExecutionWrapper(actionService, action, actionedUponNodeRef, checkConditions, actionChain, executedRules);
        boolean newActionShouldBeFilteredOut = false;
        OngoingAsyncAction nodeBeingNewlyActioned = new OngoingAsyncAction(actionedUponNodeRef, action);
        for (Map.Entry<String, AbstractAsynchronousActionFilter> entry : this.actionFilters.entrySet()) {
            AbstractAsynchronousActionFilter comparator = entry.getValue();
            String actionDefinitionName = comparator.getActionDefinitionName();
            if (!actionDefinitionName.equals(action.getActionDefinitionName())) continue;
            List<OngoingAsyncAction> list = this.ongoingActions;
            synchronized (list) {
                for (OngoingAsyncAction ongoingAction : this.ongoingActions) {
                    if (comparator.compare(ongoingAction, nodeBeingNewlyActioned) != 0) continue;
                    newActionShouldBeFilteredOut = true;
                    break;
                }
            }
        }
        if (newActionShouldBeFilteredOut) {
            if (logger.isDebugEnabled()) {
                msg = new StringBuilder();
                msg.append("Dropping action ").append(action).append(" as equivalent is ongoing.");
                logger.debug((Object)msg.toString());
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            msg = new StringBuilder();
            msg.append("Executing action ").append(action);
            logger.debug((Object)msg.toString());
        }
        this.ongoingActions.add(nodeBeingNewlyActioned);
        this.threadPoolExecutor.execute(runnable);
        if (logger.isDebugEnabled()) {
            Exception e = new Exception();
            e.fillInStackTrace();
            StackTraceElement[] trace = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append("\n").append("Placed action on execution queue: \n").append("   Action:     " + String.valueOf(action));
            String msg3 = sb.toString();
            sb = new StringBuilder();
            StackTraceUtil.buildStackTrace((String)msg3, (StackTraceElement[])trace, (StringBuilder)sb, (int)-1);
            logger.debug((Object)sb);
        }
    }

    private void handleAsyncActionIsCompleted(NodeRef n, Action action) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Completed action ").append(action);
            logger.debug((Object)msg.toString());
        }
        OngoingAsyncAction ongoing = new OngoingAsyncAction(n, action);
        this.ongoingActions.remove(ongoing);
    }

    private class ActionExecutionWrapper
    implements Runnable {
        private RuntimeActionService actionService;
        private Action action;
        private NodeRef actionedUponNodeRef;
        private boolean checkConditions;
        private Set<String> actionChain;
        private Set<RuleServiceImpl.ExecutedRuleData> executedRules;

        public ActionExecutionWrapper(RuntimeActionService actionService, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, Set<String> actionChain, Set<RuleServiceImpl.ExecutedRuleData> executedRules) {
            this.actionService = actionService;
            this.actionedUponNodeRef = actionedUponNodeRef;
            this.action = action;
            this.checkConditions = checkConditions;
            this.actionChain = actionChain;
            this.executedRules = executedRules;
        }

        @Override
        public void run() {
            block3: {
                try {
                    String userName = ((ActionImpl)this.action).getRunAsUser();
                    if (userName == null) {
                        throw new ActionServiceException("Cannot execute action asynchronously since run as user is 'null'");
                    }
                    String tenantId = ((ActionImpl)this.action).getTenantId();
                    ((ActionImpl)this.action).setExecuteAsynchronously(true);
                    TenantUtil.TenantRunAsWork<Object> actionRunAs = new TenantUtil.TenantRunAsWork<Object>(){

                        public Object doWork() throws Exception {
                            RetryingTransactionHelper.RetryingTransactionCallback<Object> actionCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                                @Override
                                public Object execute() {
                                    if ((this).ActionExecutionWrapper.this.executedRules != null) {
                                        AlfrescoTransactionSupport.bindResource((Object)"RuleServiceImpl.ExecutedRules", (this).ActionExecutionWrapper.this.executedRules);
                                    }
                                    AlfrescoTransactionSupport.bindListener((TransactionListener)new CallbackTransactionListener((this).ActionExecutionWrapper.this.action, (this).ActionExecutionWrapper.this.actionedUponNodeRef));
                                    (this).ActionExecutionWrapper.this.actionService.executeActionImpl((this).ActionExecutionWrapper.this.action, (this).ActionExecutionWrapper.this.actionedUponNodeRef, (this).ActionExecutionWrapper.this.checkConditions, true, (this).ActionExecutionWrapper.this.actionChain);
                                    return null;
                                }
                            };
                            return ((ActionExecutionWrapper)ActionExecutionWrapper.this).AsynchronousActionExecutionQueueImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(actionCallback);
                        }
                    };
                    TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)actionRunAs, (String)userName, (String)tenantId);
                }
                catch (Throwable e) {
                    Throwable rootCause = e instanceof AlfrescoRuntimeException ? ((AlfrescoRuntimeException)e).getRootCause() : null;
                    Object message = rootCause == null ? null : rootCause.getMessage();
                    message = "Failed to execute asynchronous action: " + String.valueOf(this.action) + (String)(message == null ? "" : ": " + (String)message);
                    if (this.actionService.onLogException(this.action, logger, rootCause, (String)message)) break block3;
                    logger.error(message, e);
                }
            }
            AsynchronousActionExecutionQueueImpl.this.handleAsyncActionIsCompleted(this.actionedUponNodeRef, this.action);
        }
    }

    public class CallbackTransactionListener
    extends TransactionListenerAdapter {
        private Action action;
        private NodeRef actionedUponNodeRef;

        public CallbackTransactionListener(Action action, NodeRef actionedUponNodeRef) {
            this.action = action;
            this.actionedUponNodeRef = actionedUponNodeRef;
        }

        public void afterCommit() {
            AsynchronousActionExecutionQueueImpl.this.invokeOnAsyncActionExecutePolicy(this.action, this.actionedUponNodeRef);
        }
    }
}

