/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.springframework.context.ApplicationContext;

public class TemporaryModels
extends ExternalResource {
    private static final Log logger = LogFactory.getLog(TemporaryModels.class);
    private final ApplicationContextInit appContextRule;
    private final Set<QName> loadedModels = new HashSet<QName>();

    public TemporaryModels(ApplicationContextInit appContextRule) {
        this.appContextRule = appContextRule;
    }

    protected void before() throws Throwable {
    }

    protected void after() {
        final RetryingTransactionHelper transactionHelper = this.getTransactionHelper();
        final DictionaryDAO dictionaryDAO = this.getDictionaryDAO();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        for (QName model : (this).TemporaryModels.this.loadedModels) {
                            dictionaryDAO.removeModel(model);
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private RetryingTransactionHelper getTransactionHelper() {
        ApplicationContext springContext = this.appContextRule.getApplicationContext();
        RetryingTransactionHelper transactionHelper = (RetryingTransactionHelper)springContext.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        return transactionHelper;
    }

    public QName loadModel(String modelPath, ClassLoader classLoader) {
        InputStream modelStream = classLoader.getResourceAsStream(modelPath);
        if (modelStream == null) {
            throw new DictionaryException("Could not find bootstrap model " + modelPath);
        }
        try {
            QName qName = this.loadModel(modelStream);
            return qName;
        }
        finally {
            try {
                modelStream.close();
            }
            catch (IOException ioe) {
                logger.warn((Object)("Failed to close model input stream for '" + modelPath + "': " + String.valueOf(ioe)));
            }
        }
    }

    public QName loadModel(InputStream modelStream) {
        try {
            M2Model model = M2Model.createModel((InputStream)modelStream);
            return this.loadModel(model);
        }
        catch (DictionaryException e) {
            throw new DictionaryException("Could not import model", (Throwable)e);
        }
    }

    private QName loadModel(M2Model model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading model: " + model.getName()));
        }
        DictionaryDAO dictionaryDAO = this.getDictionaryDAO();
        QName modelQName = dictionaryDAO.putModel(model);
        this.loadedModels.add(modelQName);
        return modelQName;
    }

    private DictionaryDAO getDictionaryDAO() {
        ApplicationContext springContext = this.appContextRule.getApplicationContext();
        DictionaryDAO dictionaryDAO = (DictionaryDAO)springContext.getBean("dictionaryDAO", DictionaryDAO.class);
        return dictionaryDAO;
    }
}

