/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.search.impl.AbstractCategoryServiceImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class SolrCategoryServiceImpl
extends AbstractCategoryServiceImpl {
    @Override
    public List<Pair<NodeRef, Integer>> getTopCategories(StoreRef storeRef, QName aspectName, int count) {
        SearchParameters searchParameters = this.createSearchTopCategoriesParameters(storeRef, aspectName, count);
        searchParameters.setLanguage("index-fts-alfresco");
        String field = searchParameters.getFieldFacets().stream().map(SearchParameters.FieldFacet::getField).findFirst().orElse("");
        try (ResultSet resultSet = null;){
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(searchParameters);
            List facetCounts = resultSet.getFieldFacet(field);
            LinkedList<Pair<NodeRef, Integer>> answer = new LinkedList<Pair<NodeRef, Integer>>();
            for (Pair term : facetCounts) {
                NodeRef nodeRef = new NodeRef((String)term.getFirst());
                Pair toAdd = this.nodeService.exists(nodeRef) ? new Pair((Object)nodeRef, (Object)((Integer)term.getSecond())) : new Pair(null, (Object)((Integer)term.getSecond()));
                answer.add((Pair<NodeRef, Integer>)toAdd);
            }
            LinkedList<Pair<NodeRef, Integer>> linkedList = answer;
            return linkedList;
        }
    }
}

