/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.patch.ibatis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.patch.AbstractPatchDAOImpl;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.mybatis.spring.SqlSessionTemplate;

public class PatchDAOImpl
extends AbstractPatchDAOImpl {
    private static Log logger = LogFactory.getLog(PatchDAOImpl.class);
    private static final String SELECT_ADM_MAX_NODE_ID = "alfresco.patch.select_admMaxNodeId";
    private static final String SELECT_NODES_BY_TYPE_AND_NAME_PATTERN = "alfresco.patch.select_nodesByTypeAndNamePattern";
    private static final String UPDATE_CONTENT_MIMETYPE_ID = "alfresco.patch.update_contentMimetypeId";
    private static final String UPDATE_PERSON_SIZECURRENT_TYPE = "alfresco.patch.update_fixSizeCurrentType";
    private static final String SELECT_COUNT_NODES_WITH_ASPECTS = "alfresco.patch.select_CountNodesWithAspectIds";
    private static final String SELECT_NODES_BY_TYPE_QNAME = "alfresco.patch.select_NodesByTypeQName";
    private static final String SELECT_NODES_BY_TYPE_URI = "alfresco.patch.select_NodesByTypeUriId";
    private static final String SELECT_NODES_BY_ASPECT_QNAME = "alfresco.patch.select_NodesByAspectQName";
    private static final String SELECT_NODES_BY_TYPE_AND_ASPECT_QNAME = "alfresco.patch.select_NodesByTypeAndAspectQNameQName";
    private static final String SELECT_NODES_BY_CONTENT_MIMETYPE = "alfresco.patch.select_NodesByContentMimetype";
    private static final String SELECT_COUNT_NODES_WITH_TYPE_ID = "alfresco.patch.select_CountNodesWithTypeId";
    private static final String SELECT_CHILDREN_OF_THE_SHARED_SURFCONFIG_FOLDER = "alfresco.patch.select_ChildrenOfTheSharedSurfConfigFolder";
    private QNameDAO qnameDAO;
    private LocaleDAO localeDAO;
    private ContentDataDAO contentDataDAO;
    protected SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    @Override
    public void startBatch() {
    }

    @Override
    public void executeBatch() {
    }

    @Override
    public long getMaxAdmNodeID() {
        Long count = (Long)this.template.selectOne(SELECT_ADM_MAX_NODE_ID);
        return count == null ? 0L : count;
    }

    @Override
    public int updateContentMimetypeIds(Long oldMimetypeId, Long newMimetypeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("newMimetypeId", newMimetypeId);
        params.put("oldMimetypeId", oldMimetypeId);
        return this.template.update(UPDATE_CONTENT_MIMETYPE_ID, params);
    }

    @Override
    public int updatePersonSizeCurrentType() {
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        Long sizeCurrentPropQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.PROP_SIZE_CURRENT).getFirst();
        params.put("sizeCurrentQNameId", sizeCurrentPropQNameId);
        return this.template.update(UPDATE_PERSON_SIZECURRENT_TYPE, params);
    }

    @Override
    public List<Pair<NodeRef, String>> getNodesOfTypeWithNamePattern(QName typeQName, String namePattern) {
        Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
        if (typeQNamePair == null) {
            return Collections.emptyList();
        }
        Long typeQNameId = (Long)typeQNamePair.getFirst();
        Pair<Long, QName> propQNamePair = this.qnameDAO.getQName(ContentModel.PROP_NAME);
        if (propQNamePair == null) {
            return Collections.emptyList();
        }
        Long propQNameId = (Long)propQNamePair.getFirst();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeQNameId", typeQNameId);
        params.put("propQNameId", propQNameId);
        params.put("namePattern", namePattern);
        final ArrayList<Pair<NodeRef, String>> results = new ArrayList<Pair<NodeRef, String>>(500);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                Map row = (Map)context.getResultObject();
                String protocol = (String)row.get("protocol");
                String identifier = (String)row.get("identifier");
                String uuid = (String)row.get("uuid");
                NodeRef nodeRef = new NodeRef(new StoreRef(protocol, identifier), uuid);
                String name = (String)row.get("name");
                Pair pair = new Pair((Object)nodeRef, (Object)name);
                results.add(pair);
            }
        };
        this.template.select(SELECT_NODES_BY_TYPE_AND_NAME_PATTERN, params, resultHandler);
        return results;
    }

    @Override
    public long getCountNodesWithAspects(Set<QName> qnames) {
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(qnames, false);
        if (qnameIds.size() == 0) {
            return 0L;
        }
        IdsEntity params = new IdsEntity();
        params.setIds(new ArrayList<Long>(qnameIds));
        Long count = (Long)this.template.selectOne(SELECT_COUNT_NODES_WITH_ASPECTS, (Object)params);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    @Override
    public List<Long> getNodesByTypeQNameId(Long typeQNameId, Long minNodeId, Long maxNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("qnameId", typeQNameId);
        params.put("minNodeId", minNodeId);
        params.put("maxNodeId", maxNodeId);
        return this.template.selectList(SELECT_NODES_BY_TYPE_QNAME, params);
    }

    @Override
    public List<Long> getNodesByTypeUriId(Long nsId, Long minNodeId, Long maxNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("nsId", nsId);
        params.put("minNodeId", minNodeId);
        params.put("maxNodeId", maxNodeId);
        return this.template.selectList(SELECT_NODES_BY_TYPE_URI, params);
    }

    @Override
    public List<Long> getNodesByAspectQNameId(Long aspectQNameId, Long minNodeId, Long maxNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("qnameId", aspectQNameId);
        params.put("minNodeId", minNodeId);
        params.put("maxNodeId", maxNodeId);
        return this.template.selectList(SELECT_NODES_BY_ASPECT_QNAME, params);
    }

    @Override
    public List<Long> getNodesByContentPropertyMimetypeId(Long mimetypeId, Long minNodeId, Long maxNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("mimetypeId", mimetypeId);
        params.put("minNodeId", minNodeId);
        params.put("maxNodeId", maxNodeId);
        return this.template.selectList(SELECT_NODES_BY_CONTENT_MIMETYPE, params);
    }

    @Override
    public List<Long> getNodesByTypeQNameAndAspectQNameId(long typeQNameId, long aspectQNameId, long minNodeId, long maxNodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("qnameId1", typeQNameId);
        params.put("qnameId2", aspectQNameId);
        params.put("minNodeId", minNodeId);
        params.put("maxNodeId", maxNodeId);
        return this.template.selectList(SELECT_NODES_BY_TYPE_AND_ASPECT_QNAME, params);
    }

    @Override
    public long getCountNodesWithTypId(QName typeQName) {
        Pair<Long, QName> qnameId = this.qnameDAO.getQName(typeQName);
        if (qnameId == null) {
            return 0L;
        }
        IdsEntity params = new IdsEntity();
        params.setIdOne((Long)qnameId.getFirst());
        Long count = (Long)this.template.selectOne(SELECT_COUNT_NODES_WITH_TYPE_ID, (Object)params);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    @Override
    public List<NodeRef> getChildrenOfTheSharedSurfConfigFolder(Long minNodeId, Long maxNodeId) {
        Pair<Long, QName> containsAssocQNamePair = this.qnameDAO.getQName(ContentModel.ASSOC_CONTAINS);
        if (containsAssocQNamePair == null) {
            return Collections.emptyList();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        Long qnameCrcSites = ChildAssocEntity.getQNameCrc(QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"sites"));
        Long qnameCrcSurfConfig = ChildAssocEntity.getQNameCrc(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"surf-config"));
        Long qnameCrcPages = ChildAssocEntity.getQNameCrc(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"pages"));
        Long qnameCrcUser = ChildAssocEntity.getQNameCrc(QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"user"));
        params.put("qnameCrcSites", qnameCrcSites);
        params.put("qnameCrcSurfConfig", qnameCrcSurfConfig);
        params.put("qnameCrcPages", qnameCrcPages);
        params.put("qnameCrcUser", qnameCrcUser);
        params.put("qnameTypeIdContains", containsAssocQNamePair.getFirst());
        params.put("minNodeId", minNodeId);
        params.put("maxNodeId", maxNodeId);
        final ArrayList<NodeRef> results = new ArrayList<NodeRef>(1000);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                Map row = (Map)context.getResultObject();
                String protocol = (String)row.get("protocol");
                String identifier = (String)row.get("identifier");
                String uuid = (String)row.get("uuid");
                NodeRef nodeRef = new NodeRef(new StoreRef(protocol, identifier), uuid);
                results.add(nodeRef);
            }
        };
        this.template.select(SELECT_CHILDREN_OF_THE_SHARED_SURFCONFIG_FOLDER, params, resultHandler);
        return results;
    }

    public static class Oracle
    extends PatchDAOImpl {
    }

    public static class PostgreSQL
    extends PatchDAOImpl {
    }
}

