/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.repo.admin.SysAdminParams;

public abstract class AlfrescoContext
extends DiskDeviceContext {
    private SysAdminParams sysAdminParams;
    private boolean isAlfrescoURLEnabled = false;
    private boolean isShareURLEnabled = false;
    public static final int DBG_FILE = 1;
    public static final int DBG_FILEIO = 2;
    public static final int DBG_SEARCH = 4;
    public static final int DBG_INFO = 8;
    public static final int DBG_LOCK = 16;
    public static final int DBG_PSEUDO = 32;
    public static final int DBG_RENAME = 64;
    private static final String[] m_filesysDebugStr = new String[]{"FILE", "FILEIO", "SEARCH", "INFO", "LOCK", "PSEUDO", "RENAME"};
    private String m_urlFileName;
    private String m_shareUrlFileName;
    public int m_debug;
    LockManager lockManager;
    OpLockManager opLockManager;

    public AlfrescoContext() {
        this.setDiskInformation(new SrvDiskInfo(2560000, 64, 512, 2304000));
        this.setFilesystemAttributes(7);
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public SysAdminParams getSysAdminParams() {
        return this.sysAdminParams;
    }

    public void setDisableChangeNotification(boolean disableChangeNotification) {
        this.enableChangeHandler(!disableChangeNotification);
    }

    public void initialize(AlfrescoDiskDriver filesysDriver) {
    }

    public String getFilesystemType() {
        return "NTFS";
    }

    public final String getURLPrefix() {
        return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + "/" + this.sysAdminParams.getAlfrescoContext() + "/";
    }

    public final String getShareUrlPrefix() {
        return this.sysAdminParams.getShareProtocol() + "://" + this.sysAdminParams.getShareHost() + ":" + this.sysAdminParams.getSharePort() + "/" + this.sysAdminParams.getShareContext() + "/";
    }

    public final String getURLFileName() {
        return this.m_urlFileName;
    }

    public final String getShareURLFileName() {
        return this.m_shareUrlFileName;
    }

    public final void setURLFileName(String urlFileName) {
        this.m_urlFileName = urlFileName;
        if (urlFileName != null && !urlFileName.endsWith(".url")) {
            throw new AlfrescoRuntimeException("URL link file must end with .url, " + urlFileName);
        }
    }

    public final void setShareURLFileName(String urlFileName) {
        this.m_shareUrlFileName = urlFileName;
        if (urlFileName != null && !urlFileName.endsWith(".url")) {
            throw new AlfrescoRuntimeException("URL Share link file must end with .url, " + urlFileName);
        }
    }

    public final void setDebug(String flagsStr) {
        int filesysDbg = 0;
        if (flagsStr != null) {
            StringTokenizer token = new StringTokenizer(flagsStr.toUpperCase(), ",");
            while (token.hasMoreTokens()) {
                String dbg = token.nextToken().trim();
                int idx = 0;
                boolean match = false;
                while (idx < m_filesysDebugStr.length && !match) {
                    if (m_filesysDebugStr[idx].equalsIgnoreCase(dbg)) {
                        match = true;
                        continue;
                    }
                    ++idx;
                }
                if (!match) {
                    throw new AlfrescoRuntimeException("Invalid filesystem debug flag, " + dbg);
                }
                filesysDbg += 1 << idx;
            }
            this.m_debug = filesysDbg;
        }
    }

    public final boolean hasDebug(int flg) {
        return (this.m_debug & flg) != 0;
    }

    public void startFilesystem(DiskSharedDevice share) throws DeviceContextException {
        super.startFilesystem(share);
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public OpLockManager getOpLockManager() {
        return this.opLockManager;
    }

    public void setOpLockManager(OpLockManager opLockManager) {
        this.opLockManager = opLockManager;
    }

    public void setAlfrescoURLEnabled(boolean isAlfrescoURLEnabled) {
        this.isAlfrescoURLEnabled = isAlfrescoURLEnabled;
    }

    public boolean isAlfrescoURLEnabled() {
        return this.isAlfrescoURLEnabled;
    }

    public void setShareURLEnabled(boolean isShareURLEnabled) {
        this.isShareURLEnabled = isShareURLEnabled;
    }

    public boolean isShareURLEnabled() {
        return this.isShareURLEnabled;
    }
}

