/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat.jobs;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.datasender.HBDataSenderService;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LockingJob
implements Job {
    private static final Log logger = LogFactory.getLog(LockingJob.class);
    private static final long LOCK_TTL = 5000L;
    public static final String COLLECTOR_KEY = "collector";
    public static final String DATA_SENDER_SERVICE_KEY = "hbDataSenderService";
    public static final String JOB_LOCK_SERVICE_KEY = "jobLockService";

    public void execute(JobExecutionContext jobexecutioncontext) throws JobExecutionException {
        JobDataMap dataMap = jobexecutioncontext.getJobDetail().getJobDataMap();
        HBBaseDataCollector collector = (HBBaseDataCollector)dataMap.get((Object)COLLECTOR_KEY);
        HBDataSenderService hbDataSenderService = (HBDataSenderService)dataMap.get((Object)DATA_SENDER_SERVICE_KEY);
        JobLockService jobLockService = (JobLockService)dataMap.get((Object)JOB_LOCK_SERVICE_KEY);
        ParameterCheck.mandatory((String)COLLECTOR_KEY, (Object)collector);
        ParameterCheck.mandatory((String)DATA_SENDER_SERVICE_KEY, (Object)hbDataSenderService);
        ParameterCheck.mandatory((String)JOB_LOCK_SERVICE_KEY, (Object)jobLockService);
        QName lockQname = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)collector.getCollectorId());
        LockCallback lockCallback = new LockCallback(lockQname);
        try {
            try {
                String lockToken = jobLockService.getLock(lockQname, 5000L);
                jobLockService.refreshLock(lockToken, lockQname, 5000L, lockCallback);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Lock acquired: " + String.valueOf(lockQname) + ": " + lockToken));
                }
                this.collectAndSendDataLocked(collector, hbDataSenderService);
            }
            catch (LockAcquisitionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping collect and send data (could not get lock): " + e.getMessage()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Finished collector job. ID: " + collector.getCollectorId()));
                }
                lockCallback.running.set(false);
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished collector job. ID: " + collector.getCollectorId()));
            }
            lockCallback.running.set(false);
        }
    }

    private void collectAndSendDataLocked(HBBaseDataCollector collector, HBDataSenderService hbDataSenderService) throws JobExecutionException {
        try {
            List<HBData> data = collector.collectData();
            hbDataSenderService.sendData(data);
        }
        catch (Exception e) {
            logger.error((Object)("Heartbeat failed to collect data for collector ID: " + collector.getCollectorId()), (Throwable)e);
        }
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);
        private QName lockQname;

        public LockCallback(QName lockQname) {
            this.lockQname = lockQname;
        }

        @Override
        public boolean isActive() {
            return this.running.get();
        }

        @Override
        public void lockReleased() {
            this.running.set(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lock release notification: " + String.valueOf(this.lockQname)));
            }
        }
    }
}

