/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.validator;

import org.alfresco.util.schemacomp.DiffContext;
import org.alfresco.util.schemacomp.Results;
import org.alfresco.util.schemacomp.ValidationResult;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.validator.SchemaVersionValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaVersionValidatorTest {
    private SchemaVersionValidator validator;
    private DbObject reference;
    private DbObject target;
    private DiffContext ctx;
    private Results results;

    @Before
    public void setUp() {
        this.validator = new SchemaVersionValidator();
        this.results = new Results();
        this.ctx = new DiffContext(null, this.results, null, null);
    }

    @Test
    public void validateWhenTargetVersionPredatesReference() {
        this.reference = this.schemaWithVersion(501);
        this.target = this.schemaWithVersion(500);
        this.validator.validate(this.reference, this.target, this.ctx);
        Assert.assertEquals((long)1L, (long)this.results.size());
        ValidationResult result = (ValidationResult)this.results.get(0);
        Assert.assertEquals((Object)500, (Object)result.getValue());
        Assert.assertEquals((Object)"version", (Object)result.getDbProperty().getPropertyName());
        Assert.assertSame((Object)this.target, (Object)result.getDbProperty().getDbObject());
    }

    @Test
    public void validateWhenTargetVersionSameAsReference() {
        this.reference = this.schemaWithVersion(501);
        this.target = this.schemaWithVersion(501);
        this.validator.validate(this.reference, this.target, this.ctx);
        Assert.assertEquals((long)0L, (long)this.results.size());
    }

    @Test
    public void validateWhenTargetVersionAfterReference() {
        this.reference = this.schemaWithVersion(501);
        this.target = this.schemaWithVersion(502);
        this.validator.validate(this.reference, this.target, this.ctx);
        Assert.assertEquals((long)0L, (long)this.results.size());
    }

    @Test
    public void testValidates() {
        Assert.assertEquals((Object)true, (Object)this.validator.validates("version"));
    }

    @Test
    public void testValidatesFullObject() {
        Assert.assertEquals((Object)false, (Object)this.validator.validatesFullObject());
    }

    private DbObject schemaWithVersion(int version) {
        return new Schema("", "", version, true);
    }
}

