/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnPropertyUpdateRuleTrigger
extends RuleTriggerAbstractBase
implements NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(OnPropertyUpdateRuleTrigger.class);
    private boolean onNewContent = false;
    private boolean ignoreEmptyContent = true;
    private boolean triggerParentRules = true;
    private RuntimeRuleService runtimeRuleService;

    public void setOnNewContent(boolean onNewContent) {
        this.onNewContent = onNewContent;
    }

    public void setIgnoreEmptyContent(boolean ignoreEmptyContent) {
        this.ignoreEmptyContent = ignoreEmptyContent;
    }

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    public void setRuntimeRuleService(RuntimeRuleService runtimeRuleService) {
        this.runtimeRuleService = runtimeRuleService;
    }

    @Override
    public void registerRuleTrigger() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    private boolean havePropertiesBeenModified(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after, boolean newNode, boolean newContentOnly) {
        if (newContentOnly && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT)) {
            return false;
        }
        HashSet<QName> keys = new HashSet<QName>(after.keySet());
        keys.addAll(before.keySet());
        boolean nonNullContentProperties = false;
        boolean newContentProperties = false;
        boolean nonNewModifiedContentProperties = false;
        boolean modifiedNonContentProperties = false;
        for (QName name : keys) {
            if (name.equals((Object)ContentModel.PROP_PREFERENCE_VALUES) || name.equals((Object)ContentModel.PROP_CASCADE_CRC)) continue;
            Serializable beforeValue = before.get(name);
            Serializable afterValue = after.get(name);
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(name);
            if (propertyDefinition == null) {
                if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) continue;
                modifiedNonContentProperties = true;
                continue;
            }
            if (propertyDefinition.isProtected()) continue;
            if (propertyDefinition.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT) && !propertyDefinition.isMultiValued()) {
                if (afterValue != null) {
                    nonNullContentProperties = true;
                }
                if (this.ignoreEmptyContent) {
                    ContentData beforeContent = OnPropertyUpdateRuleTrigger.toContentData(before.get(name));
                    ContentData afterContent = OnPropertyUpdateRuleTrigger.toContentData(after.get(name));
                    if (!ContentData.hasContent((ContentData)beforeContent) || beforeContent.getSize() == 0L) {
                        beforeValue = null;
                    }
                    if (!ContentData.hasContent((ContentData)afterContent) || afterContent.getSize() == 0L) {
                        afterValue = null;
                    }
                }
                if (newNode) {
                    if (afterValue == null) continue;
                    newContentProperties = true;
                    continue;
                }
                if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) continue;
                if (beforeValue == null) {
                    newContentProperties = true;
                    continue;
                }
                nonNewModifiedContentProperties = true;
                continue;
            }
            if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)afterValue)) continue;
            modifiedNonContentProperties = true;
        }
        if (newContentOnly) {
            return newNode && !nonNullContentProperties || newContentProperties;
        }
        return modifiedNonContentProperties || nonNewModifiedContentProperties;
    }

    private static ContentData toContentData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ContentData) {
            return (ContentData)object;
        }
        if (object instanceof Collection && !((Collection)object).isEmpty()) {
            return OnPropertyUpdateRuleTrigger.toContentData(((Collection)object).iterator().next());
        }
        return null;
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (!this.areRulesEnabled()) {
            return;
        }
        Set newNodeRefSet = TransactionalResourceHelper.getSet("RuleTrigger.NewNodes");
        boolean wasCreatedInTxn = newNodeRefSet.contains(nodeRef);
        if (wasCreatedInTxn) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Receiving property update for node created in transaction: " + String.valueOf(nodeRef)));
            }
            if (this.onNewContent) {
                if (this.havePropertiesBeenModified(nodeRef, before, after, true, true)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("New node " + nodeRef.toString() + " confirmed to have no content properties or to have new content so firing inbound rules."));
                    }
                    this.triggerRules(nodeRef);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Removing the pending rules for the new node " + nodeRef.toString() + " since there are no non-empty content properties."));
                    }
                    this.runtimeRuleService.removeRulePendingExecution(nodeRef);
                }
            }
        } else if (!wasCreatedInTxn && before.size() != 0 && this.havePropertiesBeenModified(nodeRef, before, after, false, this.onNewContent)) {
            if (!EqualsHelper.nullSafeEquals((Object)before.get(ContentModel.PROP_NAME), (Object)after.get(ContentModel.PROP_NAME))) {
                Set renamedNodeRefSet = TransactionalResourceHelper.getSet("RuleTrigger.RenamedNodes");
                renamedNodeRefSet.add(nodeRef);
            }
            this.triggerRules(nodeRef);
        }
    }

    private void triggerRules(NodeRef nodeRef) {
        if (this.triggerParentRules) {
            List parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
            for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("OnPropertyUpdate rule triggered (parent); nodeRef=" + String.valueOf(parentAssocRef.getParentRef())));
            }
        } else {
            this.triggerRules(nodeRef, nodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OnPropertyUpdate rule triggered; nodeRef=" + String.valueOf(nodeRef)));
            }
        }
    }
}

