/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache;

import java.util.Map;
import org.alfresco.repo.cache.CacheStatisticsCreated;
import org.alfresco.repo.cache.InMemoryCacheStatistics;
import org.alfresco.repo.cache.NoStatsForCache;
import org.alfresco.repo.cache.OperationStats;
import org.alfresco.repo.cache.TransactionStats;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class InMemoryCacheStatisticsTest {
    InMemoryCacheStatistics cacheStats;
    @Mock
    ApplicationContext appCtx;

    @Before
    public void setUp() throws Exception {
        this.cacheStats = new InMemoryCacheStatistics();
        this.cacheStats.setApplicationContext(this.appCtx);
    }

    @Test
    public void readOperationsThrowNoCacheStatsException() {
        try {
            this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT);
            Assert.fail((String)"NoStatsForCache should have been thrown.");
        }
        catch (NoStatsForCache noStatsForCache) {}
        try {
            this.cacheStats.hitMissRatio("cache1");
            Assert.fail((String)"NoStatsForCache should have been thrown.");
        }
        catch (NoStatsForCache noStatsForCache) {}
        try {
            this.cacheStats.meanTime("cache1", TransactionStats.OpType.GET_HIT);
            Assert.fail((String)"NoStatsForCache should have been thrown.");
        }
        catch (NoStatsForCache noStatsForCache) {}
        try {
            this.cacheStats.numGets("cache1");
            Assert.fail((String)"NoStatsForCache should have been thrown.");
        }
        catch (NoStatsForCache noStatsForCache) {}
        try {
            this.cacheStats.allStats("cache1");
            Assert.fail((String)"NoStatsForCache should have been thrown.");
        }
        catch (NoStatsForCache noStatsForCache) {}
    }

    @Test
    public void canAccumulateStatisticsPerCache() {
        TransactionStats txStats = new TransactionStats();
        txStats.record(0L, 1000L, TransactionStats.OpType.GET_HIT);
        txStats.record(0L, 2000L, TransactionStats.OpType.GET_HIT);
        txStats.record(0L, 3000L, TransactionStats.OpType.GET_HIT);
        this.cacheStats.add("cache1", txStats);
        ((ApplicationContext)Mockito.verify((Object)this.appCtx)).publishEvent((ApplicationEvent)Mockito.any(CacheStatisticsCreated.class));
        Assert.assertEquals((long)3L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((double)2000.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.GET_HIT), (double)0.0);
        txStats = new TransactionStats();
        txStats.record(0L, 4000L, TransactionStats.OpType.GET_HIT);
        txStats.record(0L, 5000L, TransactionStats.OpType.GET_HIT);
        Assert.assertEquals((long)3L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT));
        this.cacheStats.add("cache1", txStats);
        Assert.assertEquals((long)5L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((double)3000.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.GET_HIT), (double)0.0);
        try {
            this.cacheStats.count("cache2", TransactionStats.OpType.GET_HIT);
            Assert.fail((String)"Expected NoStatsForCache error.");
        }
        catch (NoStatsForCache noStatsForCache) {}
        txStats = new TransactionStats();
        txStats.record(0L, 4000L, TransactionStats.OpType.GET_HIT);
        txStats.record(8000L, 9000L, TransactionStats.OpType.GET_HIT);
        this.cacheStats.add("cache2", txStats);
        Assert.assertEquals((long)2L, (long)this.cacheStats.count("cache2", TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((double)2500.0, (double)this.cacheStats.meanTime("cache2", TransactionStats.OpType.GET_HIT), (double)0.0);
        Assert.assertEquals((long)5L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((double)3000.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.GET_HIT), (double)0.0);
        txStats = new TransactionStats();
        txStats.record(0L, 810L, TransactionStats.OpType.GET_MISS);
        txStats.record(1000L, 1820L, TransactionStats.OpType.PUT);
        txStats.record(3000L, 3830L, TransactionStats.OpType.REMOVE);
        txStats.record(4000L, 4840L, TransactionStats.OpType.CLEAR);
        this.cacheStats.add("cache1", txStats);
        Assert.assertEquals((long)5L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((double)3000.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.GET_HIT), (double)0.0);
        Assert.assertEquals((long)1L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_MISS));
        Assert.assertEquals((double)810.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.GET_MISS), (double)0.01);
        Assert.assertEquals((long)1L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.PUT));
        Assert.assertEquals((double)820.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.PUT), (double)0.01);
        Assert.assertEquals((long)1L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.REMOVE));
        Assert.assertEquals((double)830.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.REMOVE), (double)0.01);
        Assert.assertEquals((long)1L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.CLEAR));
        Assert.assertEquals((double)840.0, (double)this.cacheStats.meanTime("cache1", TransactionStats.OpType.CLEAR), (double)0.01);
        Assert.assertEquals((long)5L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_HIT));
        Assert.assertEquals((long)1L, (long)this.cacheStats.count("cache1", TransactionStats.OpType.GET_MISS));
        Assert.assertEquals((double)0.83, (double)this.cacheStats.hitMissRatio("cache1"), (double)0.01);
        Assert.assertEquals((long)6L, (long)this.cacheStats.numGets("cache1"));
        Map snapshot = this.cacheStats.allStats("cache1");
        Assert.assertEquals((long)5L, (long)((OperationStats)snapshot.get(TransactionStats.OpType.GET_HIT)).getCount());
        Assert.assertEquals((long)1L, (long)((OperationStats)snapshot.get(TransactionStats.OpType.GET_MISS)).getCount());
    }

    @Test
    public void canRetrieveSnapshotOfAllStats() {
        TransactionStats txStats = new TransactionStats();
        txStats.record(0L, 1000L, TransactionStats.OpType.GET_HIT);
        this.cacheStats.add("cache1", txStats);
        Map snapshot1 = this.cacheStats.allStats("cache1");
        Assert.assertEquals((long)1L, (long)((OperationStats)snapshot1.get(TransactionStats.OpType.GET_HIT)).getCount());
        Assert.assertEquals((double)1000.0, (double)((OperationStats)snapshot1.get(TransactionStats.OpType.GET_HIT)).getTotalTime(), (double)0.0);
        Assert.assertEquals((long)0L, (long)((OperationStats)snapshot1.get(TransactionStats.OpType.CLEAR)).getCount());
        Assert.assertEquals((long)0L, (long)((OperationStats)snapshot1.get(TransactionStats.OpType.PUT)).getCount());
        Assert.assertEquals((long)0L, (long)((OperationStats)snapshot1.get(TransactionStats.OpType.REMOVE)).getCount());
        Assert.assertEquals((long)0L, (long)((OperationStats)snapshot1.get(TransactionStats.OpType.GET_MISS)).getCount());
        txStats = new TransactionStats();
        txStats.record(0L, 2000L, TransactionStats.OpType.GET_HIT);
        this.cacheStats.add("cache1", txStats);
        Map snapshot2 = this.cacheStats.allStats("cache1");
        Assert.assertEquals((long)2L, (long)((OperationStats)snapshot2.get(TransactionStats.OpType.GET_HIT)).getCount());
        Assert.assertEquals((double)3000.0, (double)((OperationStats)snapshot2.get(TransactionStats.OpType.GET_HIT)).getTotalTime(), (double)0.0);
        Assert.assertEquals((long)1L, (long)((OperationStats)snapshot1.get(TransactionStats.OpType.GET_HIT)).getCount());
        Assert.assertEquals((double)1000.0, (double)((OperationStats)snapshot1.get(TransactionStats.OpType.GET_HIT)).getTotalTime(), (double)0.0);
    }
}

