/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.alfresco.repo.security.permissions.impl.model.Permission;
import org.alfresco.repo.security.permissions.impl.model.PermissionGroup;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Element;

public final class PermissionSet
implements XMLModelInitialisable {
    private static final String TYPE = "type";
    private static final String PERMISSION_GROUP = "permissionGroup";
    private static final String PERMISSION = "permission";
    private static final String EXPOSE = "expose";
    private static final String EXPOSE_ALL = "all";
    private QName qname;
    private boolean exposeAll;
    private Set<PermissionGroup> permissionGroups = new LinkedHashSet<PermissionGroup>(32, 1.0f);
    private Set<Permission> permissions = new HashSet<Permission>(32, 1.0f);

    @Override
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        this.qname = QName.createQName((String)element.attributeValue(TYPE), (NamespacePrefixResolver)nspr);
        Attribute exposeAttribute = element.attribute(EXPOSE);
        this.exposeAll = exposeAttribute != null ? exposeAttribute.getStringValue().equalsIgnoreCase(EXPOSE_ALL) : true;
        Iterator pgit = element.elementIterator(PERMISSION_GROUP);
        while (pgit.hasNext()) {
            Element permissionGroupElement = (Element)pgit.next();
            PermissionGroup permissionGroup = new PermissionGroup(this.qname);
            permissionGroup.initialise(permissionGroupElement, nspr, permissionModel);
            this.permissionGroups.add(permissionGroup);
        }
        Iterator pit = element.elementIterator(PERMISSION);
        while (pit.hasNext()) {
            Element permissionElement = (Element)pit.next();
            Permission permission = new Permission(this.qname);
            permission.initialise(permissionElement, nspr, permissionModel);
            this.permissions.add(permission);
        }
    }

    public Set<PermissionGroup> getPermissionGroups() {
        return Collections.unmodifiableSet(this.permissionGroups);
    }

    public Set<Permission> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public QName getQName() {
        return this.qname;
    }

    public boolean exposeAll() {
        return this.exposeAll;
    }
}

