/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.subsystems;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AbstractChainingAuthenticationService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.springframework.context.ApplicationContext;

public class SubsystemChainingAuthenticationService
extends AbstractChainingAuthenticationService {
    private ChildApplicationContextManager applicationContextManager;
    private String sourceBeanName;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Collection<String> instanceIds;
    private Map<String, ApplicationContext> contexts = new TreeMap<String, ApplicationContext>();
    private Map<String, Object> sourceBeans = new TreeMap<String, Object>();

    public void setApplicationContextManager(ChildApplicationContextManager applicationContextManager) {
        this.applicationContextManager = applicationContextManager;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    private void refreshBeans() {
        boolean haveWriteLock = false;
        try {
            if (this.instanceIds == null || !this.instanceIds.equals(this.applicationContextManager.getInstanceIds())) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                haveWriteLock = true;
                this.instanceIds = this.applicationContextManager.getInstanceIds();
                this.contexts.keySet().retainAll(this.instanceIds);
                this.sourceBeans.keySet().retainAll(this.instanceIds);
            }
            for (String instance : this.instanceIds) {
                ApplicationContext newContext;
                try {
                    newContext = this.applicationContextManager.getApplicationContext(instance);
                }
                catch (RuntimeException runtimeException) {
                    newContext = null;
                }
                ApplicationContext context = this.contexts.get(instance);
                if (context == newContext) continue;
                if (!haveWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    haveWriteLock = true;
                }
                try {
                    newContext = this.applicationContextManager.getApplicationContext(instance);
                    this.contexts.put(instance, newContext);
                    this.sourceBeans.put(instance, newContext.getBean(this.sourceBeanName));
                }
                catch (RuntimeException runtimeException) {
                    this.contexts.remove(instance);
                    this.sourceBeans.remove(instance);
                }
            }
        }
        finally {
            if (haveWriteLock) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public MutableAuthenticationService getMutableAuthenticationService() {
        this.lock.readLock().lock();
        try {
            this.refreshBeans();
            for (String instance : this.instanceIds) {
                AuthenticationService authenticationService = (AuthenticationService)this.sourceBeans.get(instance);
                if (!(authenticationService instanceof MutableAuthenticationService) || authenticationService instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationService)).isActive()) continue;
                MutableAuthenticationService mutableAuthenticationService = (MutableAuthenticationService)authenticationService;
                return mutableAuthenticationService;
            }
            return null;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    protected List<AuthenticationService> getUsableAuthenticationServices() {
        LinkedList<AuthenticationService> result = new LinkedList<AuthenticationService>();
        this.lock.readLock().lock();
        try {
            this.refreshBeans();
            for (String instance : this.instanceIds) {
                AuthenticationService authenticationService = (AuthenticationService)this.sourceBeans.get(instance);
                if (authenticationService == null || authenticationService instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationService)).isActive()) continue;
                result.add(authenticationService);
            }
            LinkedList<AuthenticationService> linkedList = result;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    protected String getId(AuthenticationService authService) {
        this.lock.readLock().lock();
        try {
            for (String instance : this.instanceIds) {
                if (!authService.equals(this.sourceBeans.get(instance))) continue;
                String string = instance;
                return string;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return super.getId(authService);
    }
}

