/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.config.xml;

import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.config.ConfigDataCache;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class RepoXMLConfigService
extends XMLConfigService
implements TenantDeployer {
    private static final Log logger = LogFactory.getLog(RepoXMLConfigService.class);
    private final ThreadLocal<ConfigDataCache.ConfigData> configUnderConstruction = new ThreadLocal();
    private TransactionService transactionService;
    private ConfigDataCache configDataCache;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setConfigDataCache(ConfigDataCache configDataCache) {
        this.configDataCache = configDataCache;
    }

    public RepoXMLConfigService(ConfigSource configSource) {
        super(configSource);
    }

    public List<ConfigDeployment> initConfig() {
        this.configDataCache.refresh();
        ConfigDataCache.ConfigData configData = (ConfigDataCache.ConfigData)this.configDataCache.get();
        return configData.getConfigDeployments();
    }

    public ConfigDataCache.ConfigData getRepoConfig(String tenantDomain) {
        final RetryingTransactionHelper.RetryingTransactionCallback<Void> getConfigWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RepoXMLConfigService.super.initConfig();
                return null;
            }
        };
        TenantUtil.TenantRunAsWork<Void> getConfigRunAs = new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoXMLConfigService.this.transactionService.getRetryingTransactionHelper().doInTransaction(getConfigWork, true);
                return null;
            }
        };
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fetching repository config data for tenant: \n   Tenant Domain: " + tenantDomain));
            }
            ConfigDataCache.ConfigData configData = new ConfigDataCache.ConfigData();
            this.configUnderConstruction.set(configData);
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)getConfigRunAs, (String)tenantDomain);
            configData = new ConfigDataCache.ImmutableConfigData(configData);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Fetched repository config data for tenant: \n   Tenant Domain: " + tenantDomain + "\n   Config:        " + String.valueOf(configData)));
            }
            ConfigDataCache.ConfigData configData2 = configData;
            return configData2;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to fetch repository config data for tenant \n   Tenant Domain: " + tenantDomain, (Throwable)e);
        }
        finally {
            this.configUnderConstruction.remove();
        }
    }

    public void destroy() {
        this.reset();
    }

    public void reset() {
        this.configDataCache.refresh();
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() {
                RepoXMLConfigService.this.initConfig();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void onEnableTenant() {
        this.initConfig();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    private ConfigDataCache.ConfigData getConfigData() {
        if (this.configUnderConstruction.get() != null) {
            return this.configUnderConstruction.get();
        }
        return (ConfigDataCache.ConfigData)this.configDataCache.get();
    }

    protected ConfigImpl getGlobalConfigImpl() {
        return this.getConfigData().getGlobalConfig();
    }

    protected void putGlobalConfig(ConfigImpl globalConfig) {
        this.getConfigData().setGlobalConfig(globalConfig);
    }

    protected void removeGlobalConfig() {
        throw new UnsupportedOperationException("'destroy' method must destroy all config.  Piecemeal destruction is not supported.");
    }

    protected Map<String, Evaluator> getEvaluators() {
        return this.getConfigData().getEvaluators();
    }

    protected void putEvaluators(Map<String, Evaluator> evaluators) {
        this.getConfigData().setEvaluators(evaluators);
    }

    protected void removeEvaluators() {
        throw new UnsupportedOperationException("'destroy' method must destroy all config.  Piecemeal destruction is not supported.");
    }

    public Map<String, List<ConfigSection>> getSectionsByArea() {
        return this.getConfigData().getSectionsByArea();
    }

    protected void putSectionsByArea(Map<String, List<ConfigSection>> sectionsByArea) {
        this.getConfigData().setSectionsByArea(sectionsByArea);
    }

    protected void removeSectionsByArea() {
        throw new UnsupportedOperationException("'destroy' method must destroy all config.  Piecemeal destruction is not supported.");
    }

    public List<ConfigSection> getSections() {
        return this.getConfigData().getSections();
    }

    protected void putSections(List<ConfigSection> sections) {
        this.getConfigData().setSections(sections);
    }

    protected void removeSections() {
        throw new UnsupportedOperationException("'destroy' method must destroy all config.  Piecemeal destruction is not supported.");
    }

    protected Map<String, ConfigElementReader> getElementReaders() {
        return this.getConfigData().getElementReaders();
    }

    protected void putElementReaders(Map<String, ConfigElementReader> elementReaders) {
        this.getConfigData().setElementReaders(elementReaders);
    }

    protected void removeElementReaders() {
        throw new UnsupportedOperationException("'destroy' method must destroy all config.  Piecemeal destruction is not supported.");
    }
}

