/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.PeerAssociationResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.repo.event2.EventJSONSchema;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.junit.Test;

public class PeerAssociationRepoEventIT
extends AbstractContextAwareRepoEvent {
    @Test
    public void testAddPeerAssociation() {
        NodeRef content1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(2);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(1);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(2);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.createAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL));
        List peerAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getSourceAssocs(content2NodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL));
        PeerAssociationRepoEventIT.assertEquals((int)1, (int)peerAssociationRefs.size());
        this.checkNumOfEvents(4);
        RepoEvent peerAssocRepoEvent = this.getFilteredEvent(EventType.PEER_ASSOC_CREATED, 0);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.PEER_ASSOC_CREATED.getType(), (String)peerAssocRepoEvent.getType());
        PeerAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available. ", (Object)peerAssocRepoEvent.getId());
        PeerAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)peerAssocRepoEvent.getSource());
        PeerAssociationRepoEventIT.assertEquals((String)"Repo event source is not available. ", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)peerAssocRepoEvent.getSource().toString());
        PeerAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available. ", (Object)peerAssocRepoEvent.getTime());
        PeerAssociationRepoEventIT.assertEquals((String)"Repo event datacontenttype", (String)"application/json", (String)peerAssocRepoEvent.getDatacontenttype());
        PeerAssociationRepoEventIT.assertNotNull((Object)peerAssocRepoEvent.getDataschema());
        PeerAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.PEER_ASSOC_CREATED_V1.getSchema(), (Object)peerAssocRepoEvent.getDataschema());
        EventData nodeResourceEventData = (EventData)this.getEventData(peerAssocRepoEvent);
        PeerAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)nodeResourceEventData.getEventGroupId());
        PeerAssociationRepoEventIT.assertNull((String)"resourceBefore property is not available", (Object)nodeResourceEventData.getResourceBefore());
        PeerAssociationResource peerAssociationResource = this.getPeerAssocResource(peerAssocRepoEvent);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong source", (String)content1NodeRef.getId(), (String)peerAssociationResource.getSource().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong target", (String)content2NodeRef.getId(), (String)peerAssociationResource.getTarget().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:original", (String)peerAssociationResource.getAssocType());
    }

    @Test
    public void testAddMultiplePeerAssociationSameTransaction() {
        NodeRef content1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content3NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(3);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(1);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(2);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(3);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.createAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            this.nodeService.createAssociation(content3NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            return null;
        });
        List peerAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getSourceAssocs(content2NodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL));
        PeerAssociationRepoEventIT.assertEquals((int)2, (int)peerAssociationRefs.size());
        this.checkNumOfEvents(7);
        List peerAssocRepoEvent = this.getFilteredEvents(EventType.PEER_ASSOC_CREATED);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)2, (int)peerAssocRepoEvent.size());
    }

    @Test
    public void testAddMultiplePeerAssociationDifferentTransaction() {
        NodeRef content1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content3NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(3);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(1);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(2);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(3);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.createAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            return null;
        });
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.createAssociation(content3NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            return null;
        });
        List peerAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getSourceAssocs(content2NodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL));
        PeerAssociationRepoEventIT.assertEquals((int)2, (int)peerAssociationRefs.size());
        this.checkNumOfEvents(7);
        List peerAssocRepoEvent = this.getFilteredEvents(EventType.PEER_ASSOC_CREATED);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong association events number", (int)2, (int)peerAssocRepoEvent.size());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong source", (String)content1NodeRef.getId(), (String)this.getPeerAssocResource(peerAssocRepoEvent.get(0)).getSource().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong target", (String)content2NodeRef.getId(), (String)this.getPeerAssocResource(peerAssocRepoEvent.get(0)).getTarget().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:original", (String)this.getPeerAssocResource(peerAssocRepoEvent.get(0)).getAssocType());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong source", (String)content3NodeRef.getId(), (String)this.getPeerAssocResource(peerAssocRepoEvent.get(1)).getSource().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong target", (String)content2NodeRef.getId(), (String)this.getPeerAssocResource(peerAssocRepoEvent.get(1)).getTarget().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:original", (String)this.getPeerAssocResource(peerAssocRepoEvent.get(1)).getAssocType());
    }

    @Test
    public void testRemovePeerAssociation() {
        NodeRef content1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(2);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(1);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(2);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.createAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL));
        List peerAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getSourceAssocs(content2NodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL));
        PeerAssociationRepoEventIT.assertEquals((int)1, (int)peerAssociationRefs.size());
        this.checkNumOfEvents(4);
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.removeAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            return null;
        });
        peerAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getSourceAssocs(content2NodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL));
        PeerAssociationRepoEventIT.assertEquals((int)0, (int)peerAssociationRefs.size());
        this.checkNumOfEvents(6);
        RepoEvent peerAssocRepoEvent = this.getFilteredEvent(EventType.PEER_ASSOC_CREATED, 0);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.PEER_ASSOC_CREATED.getType(), (String)peerAssocRepoEvent.getType());
        PeerAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available. ", (Object)peerAssocRepoEvent.getId());
        PeerAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)peerAssocRepoEvent.getSource());
        PeerAssociationRepoEventIT.assertEquals((String)"Repo event source is not available. ", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)peerAssocRepoEvent.getSource().toString());
        PeerAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available. ", (Object)peerAssocRepoEvent.getTime());
        PeerAssociationRepoEventIT.assertEquals((String)"Repo event datacontenttype", (String)"application/json", (String)peerAssocRepoEvent.getDatacontenttype());
        PeerAssociationRepoEventIT.assertNotNull((Object)peerAssocRepoEvent.getDataschema());
        PeerAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.PEER_ASSOC_CREATED_V1.getSchema(), (Object)peerAssocRepoEvent.getDataschema());
        EventData nodeResourceEventData = (EventData)this.getEventData(peerAssocRepoEvent);
        PeerAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)nodeResourceEventData.getEventGroupId());
        PeerAssociationRepoEventIT.assertNull((String)"resourceBefore property is not available", (Object)nodeResourceEventData.getResourceBefore());
        PeerAssociationResource peerAssociationResource = this.getPeerAssocResource(peerAssocRepoEvent);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong source", (String)content1NodeRef.getId(), (String)peerAssociationResource.getSource().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong target", (String)content2NodeRef.getId(), (String)peerAssociationResource.getTarget().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:original", (String)peerAssociationResource.getAssocType());
        RepoEvent peerAssocRepoEvent2 = this.getFilteredEvent(EventType.PEER_ASSOC_DELETED, 0);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.PEER_ASSOC_DELETED.getType(), (String)peerAssocRepoEvent2.getType());
        PeerAssociationRepoEventIT.assertNotNull((String)"Repo event ID is not available. ", (Object)peerAssocRepoEvent2.getId());
        PeerAssociationRepoEventIT.assertNotNull((String)"Source is not available", (Object)peerAssocRepoEvent2.getSource());
        PeerAssociationRepoEventIT.assertEquals((String)"Repo event source is not available. ", (String)("/" + this.descriptorService.getCurrentRepositoryDescriptor().getId()), (String)peerAssocRepoEvent2.getSource().toString());
        PeerAssociationRepoEventIT.assertNotNull((String)"Repo event creation time is not available. ", (Object)peerAssocRepoEvent2.getTime());
        PeerAssociationRepoEventIT.assertEquals((String)"Repo event datacontenttype", (String)"application/json", (String)peerAssocRepoEvent2.getDatacontenttype());
        PeerAssociationRepoEventIT.assertNotNull((Object)peerAssocRepoEvent2.getDataschema());
        PeerAssociationRepoEventIT.assertEquals((Object)EventJSONSchema.PEER_ASSOC_DELETED_V1.getSchema(), (Object)peerAssocRepoEvent2.getDataschema());
        EventData nodeResourceEventData2 = (EventData)this.getEventData(peerAssocRepoEvent2);
        PeerAssociationRepoEventIT.assertNotNull((String)"Event data group ID is not available. ", (Object)nodeResourceEventData2.getEventGroupId());
        PeerAssociationRepoEventIT.assertNull((String)"resourceBefore property is not available", (Object)nodeResourceEventData2.getResourceBefore());
        PeerAssociationResource peerAssociationResource2 = this.getPeerAssocResource(peerAssocRepoEvent2);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong source", (String)content1NodeRef.getId(), (String)peerAssociationResource2.getSource().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong target", (String)content2NodeRef.getId(), (String)peerAssociationResource2.getTarget().getId());
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong assoc type", (String)"cm:original", (String)peerAssociationResource2.getAssocType());
    }

    @Test
    public void testAddAndRemovePeerAssociationSameTransaction() {
        NodeRef content1NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        NodeRef content2NodeRef = this.createNode(ContentModel.TYPE_CONTENT);
        this.checkNumOfEvents(2);
        RepoEvent resultRepoEvent = this.getRepoEventWithoutWait(1);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        resultRepoEvent = this.getRepoEventWithoutWait(2);
        PeerAssociationRepoEventIT.assertEquals((String)"Wrong repo event type.", (String)EventType.NODE_CREATED.getType(), (String)resultRepoEvent.getType());
        this.retryingTransactionHelper.doInTransaction(() -> {
            this.nodeService.createAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            this.nodeService.removeAssociation(content1NodeRef, content2NodeRef, ContentModel.ASSOC_ORIGINAL);
            return null;
        });
        List peerAssociationRefs = (List)this.retryingTransactionHelper.doInTransaction(() -> this.nodeService.getSourceAssocs(content2NodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL));
        PeerAssociationRepoEventIT.assertEquals((int)0, (int)peerAssociationRefs.size());
        this.checkNumOfEvents(2);
    }
}

