/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ActionExecuter;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.xml.XPathMetadataExtracter;
import org.alfresco.repo.content.metadata.xml.XmlMetadataExtracter;
import org.alfresco.repo.content.selector.RootElementNameContentWorkerSelector;
import org.alfresco.repo.content.selector.XPathContentWorkerSelector;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Category(value={NeverRunsTests.class})
public class XmlMetadataExtracterTest
extends TestCase {
    private static final String FILE_ALFRESCO_MODEL = "xml-metadata/alfresco-model-sample.xml";
    private static final String FILE_DITA_FILE = "xml-metadata/dita-concept-quick.xml";
    private static final String FILE_ECLIPSE_PROJECT = "xml-metadata/eclipse-project-sample.xml";
    private static final String FILE_EMPTY = "xml-metadata/empty-sample.xml";
    private static final String FILE_MALFORMED = "xml-metadata/malformed-sample.xml";
    private static final String CTX_LOCATION = "classpath:xml-metadata/xml-metadata-test-context.xml";
    private static final ApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:xml-metadata/xml-metadata-test-context.xml");
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private XPathMetadataExtracter alfrescoModelMetadataExtracter;
    private XPathMetadataExtracter eclipseProjectMetadataExtracter;
    private XPathMetadataExtracter ditaConceptMetadataExtracter;
    private RootElementNameContentWorkerSelector<MetadataExtracter> rootElementNameMetadataExtracterSelector;
    private XPathContentWorkerSelector<MetadataExtracter> xpathMetadataExtracterSelector;
    private XmlMetadataExtracter xmlMetadataExtracter;

    private static final ContentReader getReader(String fileName) throws FileNotFoundException {
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource(fileName);
        if (url == null) {
            throw new FileNotFoundException("Could not find file on classpath: " + fileName);
        }
        File file = new File(url.getFile());
        if (!file.exists()) {
            throw new FileNotFoundException("Could not find file on classpath: " + fileName);
        }
        FileContentReader reader = new FileContentReader(file);
        reader.setMimetype("text/xml");
        return reader;
    }

    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.alfrescoModelMetadataExtracter = (XPathMetadataExtracter)ctx.getBean("extracter.xml.AlfrescoModelMetadataExtracter");
        this.eclipseProjectMetadataExtracter = (XPathMetadataExtracter)ctx.getBean("extracter.xml.EclipseProjectMetadataExtracter");
        this.ditaConceptMetadataExtracter = (XPathMetadataExtracter)ctx.getBean("extracter.xml.DITAConceptMetadataExtracter");
        this.rootElementNameMetadataExtracterSelector = (RootElementNameContentWorkerSelector)ctx.getBean("extracter.xml.selector.RootElementSelector");
        this.xpathMetadataExtracterSelector = (XPathContentWorkerSelector)ctx.getBean("extracter.xml.selector.XPathSelector");
        this.xmlMetadataExtracter = (XmlMetadataExtracter)ctx.getBean("extracter.xml.XMLMetadataExtracter");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {}
    }

    public void testSetUp() {
        XmlMetadataExtracterTest.assertNotNull((Object)this.alfrescoModelMetadataExtracter);
        XmlMetadataExtracterTest.assertNotNull((Object)this.eclipseProjectMetadataExtracter);
    }

    public void testExtractAlfresocModel() throws Exception {
        ContentReader reader = XmlMetadataExtracterTest.getReader(FILE_ALFRESCO_MODEL);
        XmlMetadataExtracterTest.assertTrue((boolean)reader.exists());
        PropertyMap checkProperties = new PropertyMap();
        this.alfrescoModelMetadataExtracter.extract(reader, (Map)checkProperties);
        XmlMetadataExtracterTest.assertEquals((String)"Gavin Cornwell", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_AUTHOR));
        XmlMetadataExtracterTest.assertEquals((String)"fm:forummodel", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"Forum Model", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_DESCRIPTION));
    }

    public void testExtractEclipseProject() throws Exception {
        ContentReader reader = XmlMetadataExtracterTest.getReader(FILE_ECLIPSE_PROJECT);
        XmlMetadataExtracterTest.assertTrue((boolean)reader.exists());
        PropertyMap checkProperties = new PropertyMap();
        this.eclipseProjectMetadataExtracter.extract(reader, (Map)checkProperties);
        XmlMetadataExtracterTest.assertEquals((String)"Repository", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"JavaCC Nature", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_DESCRIPTION));
    }

    public void testDITAFileWithDoctype() throws Exception {
        ContentReader reader = XmlMetadataExtracterTest.getReader(FILE_DITA_FILE);
        XmlMetadataExtracterTest.assertTrue((boolean)reader.exists());
        String contents = reader.getContentString();
        XmlMetadataExtracterTest.assertTrue((String)"DOCTYPE should be present but wasn't", (contents.indexOf("<!DOCTYPE") > -1 ? 1 : 0) != 0);
        reader = reader.getReader();
        this.doTestDITAFile(reader);
    }

    public void testDITAFileWithoutDoctype() throws Exception {
        ContentReader reader = XmlMetadataExtracterTest.getReader(FILE_DITA_FILE);
        XmlMetadataExtracterTest.assertTrue((boolean)reader.exists());
        String contents = reader.getContentString();
        String noDocType = contents.replaceAll("<!DOCTYPE.*?>", "");
        File tmp = File.createTempFile("alfresco", ".xml");
        tmp.deleteOnExit();
        FileContentWriter w = new FileContentWriter(tmp);
        w.setEncoding(reader.getEncoding());
        w.setMimetype(reader.getMimetype());
        w.putContent(noDocType);
        this.doTestDITAFile(w.getReader());
    }

    private void doTestDITAFile(ContentReader reader) throws Exception {
        PropertyMap checkProperties = new PropertyMap();
        this.ditaConceptMetadataExtracter.extract(reader, (Map)checkProperties);
        XmlMetadataExtracterTest.assertEquals((String)"The quick brown fox jumps over the lazy dog", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"Pangram, fox, dog, Gym class featuring a brown fox and lazy dog", (String)this.getPropertyValue(checkProperties, ContentModel.PROP_DESCRIPTION));
    }

    public void testEmptyFile() throws Exception {
        ContentReader reader = XmlMetadataExtracterTest.getReader(FILE_EMPTY);
        XmlMetadataExtracterTest.assertTrue((boolean)reader.exists());
        PropertyMap checkProperties = new PropertyMap();
        checkProperties.put((Object)ContentModel.PROP_TITLE, (Object)this.getName());
        this.xmlMetadataExtracter.extract(reader, (Map)checkProperties);
        XmlMetadataExtracterTest.assertNotNull((String)"Properties changed by empty file extraction", (Object)checkProperties.get((Object)ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"Properties changed by empty file extraction", (Object)this.getName(), (Object)checkProperties.get((Object)ContentModel.PROP_TITLE));
    }

    public void testMalformedFile() throws Exception {
        ContentReader reader = XmlMetadataExtracterTest.getReader(FILE_MALFORMED);
        XmlMetadataExtracterTest.assertTrue((boolean)reader.exists());
        PropertyMap checkProperties = new PropertyMap();
        checkProperties.put((Object)ContentModel.PROP_TITLE, (Object)this.getName());
        this.xmlMetadataExtracter.extract(reader, (Map)checkProperties);
        XmlMetadataExtracterTest.assertNotNull((String)"Properties changed by malformed file extraction", (Object)checkProperties.get((Object)ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"Properties changed by malformed file extraction", (Object)this.getName(), (Object)checkProperties.get((Object)ContentModel.PROP_TITLE));
    }

    public void testRootElementNameSelector() throws Exception {
        ContentReader alfrescoModelReader = XmlMetadataExtracterTest.getReader(FILE_ALFRESCO_MODEL);
        XmlMetadataExtracterTest.assertTrue((boolean)alfrescoModelReader.exists());
        ContentReader eclipseProjectReader = XmlMetadataExtracterTest.getReader(FILE_ECLIPSE_PROJECT);
        XmlMetadataExtracterTest.assertTrue((boolean)eclipseProjectReader.exists());
        MetadataExtracter alfrescoModelExtracter = (MetadataExtracter)this.rootElementNameMetadataExtracterSelector.getWorker(alfrescoModelReader);
        XmlMetadataExtracterTest.assertNotNull((String)"Failed to select correct extracter", (Object)alfrescoModelExtracter);
        XmlMetadataExtracterTest.assertTrue((String)"Incorrect extracter instance selected", (this.alfrescoModelMetadataExtracter == alfrescoModelExtracter ? 1 : 0) != 0);
        XmlMetadataExtracterTest.assertFalse((String)"Read channel not closed", (boolean)alfrescoModelReader.isChannelOpen());
        MetadataExtracter eclipseProjectExtracter = (MetadataExtracter)this.rootElementNameMetadataExtracterSelector.getWorker(eclipseProjectReader);
        XmlMetadataExtracterTest.assertNotNull((String)"Failed to select correct extracter", (Object)eclipseProjectExtracter);
        XmlMetadataExtracterTest.assertTrue((String)"Incorrect extracter instance selected", (this.eclipseProjectMetadataExtracter == eclipseProjectExtracter ? 1 : 0) != 0);
        XmlMetadataExtracterTest.assertFalse((String)"Read channel not closed", (boolean)eclipseProjectReader.isChannelOpen());
    }

    public void testXpathSelector() throws Exception {
        ContentReader alfrescoModelReader = XmlMetadataExtracterTest.getReader(FILE_ALFRESCO_MODEL);
        XmlMetadataExtracterTest.assertTrue((boolean)alfrescoModelReader.exists());
        ContentReader eclipseProjectReader = XmlMetadataExtracterTest.getReader(FILE_ECLIPSE_PROJECT);
        XmlMetadataExtracterTest.assertTrue((boolean)eclipseProjectReader.exists());
        MetadataExtracter alfrescoModelExtracter = (MetadataExtracter)this.xpathMetadataExtracterSelector.getWorker(alfrescoModelReader);
        XmlMetadataExtracterTest.assertNotNull((String)"Failed to select correct extracter", (Object)alfrescoModelExtracter);
        XmlMetadataExtracterTest.assertTrue((String)"Incorrect extracter instance selected", (this.alfrescoModelMetadataExtracter == alfrescoModelExtracter ? 1 : 0) != 0);
        XmlMetadataExtracterTest.assertFalse((String)"Read channel not closed", (boolean)alfrescoModelReader.isChannelOpen());
        MetadataExtracter eclipseProjectExtracter = (MetadataExtracter)this.xpathMetadataExtracterSelector.getWorker(eclipseProjectReader);
        XmlMetadataExtracterTest.assertNotNull((String)"Failed to select correct extracter", (Object)eclipseProjectExtracter);
        XmlMetadataExtracterTest.assertTrue((String)"Incorrect extracter instance selected", (this.eclipseProjectMetadataExtracter == eclipseProjectExtracter ? 1 : 0) != 0);
        XmlMetadataExtracterTest.assertFalse((String)"Read channel not closed", (boolean)eclipseProjectReader.isChannelOpen());
    }

    public void testXmlMetadataExtracter() throws Exception {
        ContentReader alfrescoModelReader = XmlMetadataExtracterTest.getReader(FILE_ALFRESCO_MODEL);
        XmlMetadataExtracterTest.assertTrue((boolean)alfrescoModelReader.exists());
        ContentReader eclipseProjectReader = XmlMetadataExtracterTest.getReader(FILE_ECLIPSE_PROJECT);
        XmlMetadataExtracterTest.assertTrue((boolean)eclipseProjectReader.exists());
        PropertyMap checkAlfrescoModelProperties = new PropertyMap();
        this.xmlMetadataExtracter.extract(alfrescoModelReader, (Map)checkAlfrescoModelProperties);
        XmlMetadataExtracterTest.assertEquals((String)"Gavin Cornwell", (String)this.getPropertyValue(checkAlfrescoModelProperties, ContentModel.PROP_AUTHOR));
        XmlMetadataExtracterTest.assertEquals((String)"fm:forummodel", (String)this.getPropertyValue(checkAlfrescoModelProperties, ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"Forum Model", (String)this.getPropertyValue(checkAlfrescoModelProperties, ContentModel.PROP_DESCRIPTION));
        PropertyMap checkEclipseProjectProperties = new PropertyMap();
        this.xmlMetadataExtracter.extract(eclipseProjectReader, (Map)checkEclipseProjectProperties);
        XmlMetadataExtracterTest.assertEquals((String)"Repository", (String)this.getPropertyValue(checkEclipseProjectProperties, ContentModel.PROP_TITLE));
        XmlMetadataExtracterTest.assertEquals((String)"JavaCC Nature", (String)this.getPropertyValue(checkEclipseProjectProperties, ContentModel.PROP_DESCRIPTION));
    }

    public void testLifecycleOfXmlMetadataExtraction() throws Exception {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        ContentService contentService = this.serviceRegistry.getContentService();
        ActionExecuter executer = (ActionExecuter)ctx.getBean("extract-metadata");
        ActionImpl action = new ActionImpl(null, GUID.generate(), "set-property-value", null);
        StoreRef storeRef = new StoreRef("test", this.getName());
        NodeRef rootNodeRef = null;
        if (nodeService.exists(storeRef)) {
            rootNodeRef = nodeService.getRootNode(storeRef);
        } else {
            nodeService.createStore("test", this.getName());
            rootNodeRef = nodeService.getRootNode(storeRef);
        }
        PropertyMap properties = new PropertyMap();
        properties.put((Object)ContentModel.PROP_TITLE, (Object)"My title");
        properties.put((Object)ContentModel.PROP_DESCRIPTION, (Object)"My description");
        NodeRef contentNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_CONTENT, (Map)properties).getChildRef();
        ContentReader alfrescoModelReader = XmlMetadataExtracterTest.getReader(FILE_ALFRESCO_MODEL);
        XmlMetadataExtracterTest.assertTrue((boolean)alfrescoModelReader.exists());
        ContentWriter writer = contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/xml");
        writer.putContent(alfrescoModelReader);
        executer.execute((Action)action, contentNodeRef);
        String checkTitle = (String)((Object)nodeService.getProperty(contentNodeRef, ContentModel.PROP_TITLE));
        String checkDescription = (String)((Object)nodeService.getProperty(contentNodeRef, ContentModel.PROP_DESCRIPTION));
        XmlMetadataExtracterTest.assertEquals((String)"fm:forummodel", (String)checkTitle);
        XmlMetadataExtracterTest.assertEquals((String)"Forum Model", (String)checkDescription);
    }

    private String getPropertyValue(PropertyMap properties, QName qname) {
        Object val = properties.get((Object)qname);
        XmlMetadataExtracterTest.assertNotNull((String)("Property " + String.valueOf(qname) + " missing, properties are " + String.valueOf(properties.keySet())), (Object)val);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof MLText) {
            return ((MLText)val).getDefaultValue();
        }
        return val.toString();
    }
}

