/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.encryption.KeyResourceLoader;
import org.alfresco.encryption.KeyStoreParameters;
import org.alfresco.encryption.KeystoreKeyProvider;
import org.alfresco.encryption.SpringKeyResourceLoader;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class KeyStoreKeyProviderTest
extends TestCase {
    private static final String FILE_ONE = "classpath:alfresco/keystore-tests/ks-test-1.jks";
    private static final String FILE_TWO = "classpath:alfresco/keystore-tests/ks-test-2.jks";
    private static final String FILE_THREE = "classpath:alfresco/keystore-tests/ks-test-3.jks";
    private static final String ALIAS_ONE = "mykey1";
    private static final String ALIAS_TWO = "mykey2";
    private static final String ALIAS_THREE = "mykey3";

    static KeystoreKeyProvider getTestKeyStoreProvider() {
        HashMap<String, String> passwords = new HashMap<String, String>(5);
        passwords.put("keystore.password", "ksPwd2");
        passwords.put(ALIAS_ONE, "aliasPwd1");
        passwords.put(ALIAS_TWO, "aliasPwd2");
        KeyStoreParameters encryptionParameters = new KeyStoreParameters("test", "JCEKS", "SunJCE", null, FILE_TWO);
        KeystoreKeyProvider keyProvider = new KeystoreKeyProvider(encryptionParameters, KeyStoreKeyProviderTest.getKeyStoreLoader(passwords));
        return keyProvider;
    }

    static KeystoreKeyProvider getTestKeyStoreProvider(String keyStoreLocation, Map<String, String> passwords) {
        KeyStoreParameters encryptionParameters = new KeyStoreParameters("test", "JCEKS", "SunJCE", null, keyStoreLocation);
        KeystoreKeyProvider keyProvider = new KeystoreKeyProvider(encryptionParameters, KeyStoreKeyProviderTest.getKeyStoreLoader(passwords));
        return keyProvider;
    }

    protected static KeyResourceLoader getKeyStoreLoader(Map<String, String> passwords) {
        return new TestKeyResourceLoader(passwords);
    }

    public void setUp() throws Exception {
    }

    public void testNoKeyStorePasswords() throws Exception {
        KeystoreKeyProvider keyProvider = KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_ONE, Collections.emptyMap());
        KeyStoreKeyProviderTest.assertNull((String)"Should be no keys available", (Object)keyProvider.getKey(ALIAS_ONE));
    }

    public void testKeyStoreWithOnlyAliasPasswords() throws Exception {
        KeystoreKeyProvider keyProvider = KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_ONE, Collections.singletonMap(ALIAS_ONE, "aliasPwd1"));
        KeyStoreKeyProviderTest.assertNotNull((String)"Should be able to key alias with same password", (Object)keyProvider.getKey(ALIAS_ONE));
    }

    public void testAliasWithIncorrectPassword_One() throws Exception {
        try {
            KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_ONE, Collections.singletonMap(ALIAS_ONE, "password_fail"));
            KeyStoreKeyProviderTest.fail((String)"Expect to fail because password is incorrect");
        }
        catch (AlfrescoRuntimeException e) {
            KeyStoreKeyProviderTest.assertTrue((boolean)(e.getCause() instanceof UnrecoverableKeyException));
        }
    }

    public void testAliasWithIncorrectPassword_Two() throws Exception {
        try {
            KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_TWO, Collections.singletonMap(ALIAS_TWO, "password_fail"));
            KeyStoreKeyProviderTest.fail((String)"Expect to fail because password is incorrect");
        }
        catch (AlfrescoRuntimeException e) {
            KeyStoreKeyProviderTest.assertTrue((boolean)(e.getCause() instanceof UnrecoverableKeyException));
        }
    }

    public void testAliasWithCorrectPassword_One() throws Exception {
        KeystoreKeyProvider ks = KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_ONE, Collections.singletonMap(ALIAS_ONE, "aliasPwd1"));
        Key keyOne = ks.getKey(ALIAS_ONE);
        KeyStoreKeyProviderTest.assertNotNull((Object)keyOne);
    }

    public void testAliasWithCorrectPassword_Two() throws Exception {
        HashMap<String, String> passwords = new HashMap<String, String>(5);
        passwords.put(ALIAS_ONE, "aliasPwd1");
        passwords.put(ALIAS_TWO, "aliasPwd2");
        KeystoreKeyProvider ks = KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_TWO, passwords);
        KeyStoreKeyProviderTest.assertNotNull((Object)ks.getKey(ALIAS_ONE));
        KeyStoreKeyProviderTest.assertNotNull((Object)ks.getKey(ALIAS_TWO));
    }

    public void testAliasWithCorrectPassword_Three() throws Exception {
        HashMap<String, String> passwords = new HashMap<String, String>(5);
        passwords.put(ALIAS_ONE, "aliasPwd1");
        passwords.put(ALIAS_TWO, "aliasPwd2");
        passwords.put(ALIAS_THREE, "aliasPwd3");
        KeystoreKeyProvider ks = KeyStoreKeyProviderTest.getTestKeyStoreProvider(FILE_THREE, passwords);
        KeyStoreKeyProviderTest.assertNotNull((Object)ks.getKey(ALIAS_ONE));
        KeyStoreKeyProviderTest.assertNotNull((Object)ks.getKey(ALIAS_TWO));
        KeyStoreKeyProviderTest.assertNull((Object)ks.getKey(ALIAS_THREE));
    }

    public void DISABLED_testSpringCrypto() throws Throwable {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"alfresco/keystore-tests/encryption-test-context.xml"});
        KeyStore cfr_ignored_0 = (KeyStore)ctx.getBean("ks-test-1");
    }

    private static class TestKeyResourceLoader
    extends SpringKeyResourceLoader {
        private Properties props;

        TestKeyResourceLoader(Map<String, String> passwords) {
            StringBuilder aliases = new StringBuilder();
            this.props = new Properties();
            int i = 0;
            for (Map.Entry<String, String> password : passwords.entrySet()) {
                this.props.put(password.getKey() + ".password", password.getValue());
                aliases.append(password.getKey());
                if (i >= passwords.size() - 1) continue;
                aliases.append(",");
                ++i;
            }
            this.props.put("aliases", aliases.toString());
        }

        public Properties loadKeyMetaData(String keyMetaDataFileLocation) throws IOException, FileNotFoundException {
            return this.props;
        }
    }
}

