/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.io.OutputFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLWriter {
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private org.dom4j.io.XMLWriter dom4jWriter;
    private NamespaceMap prefixResolver = new NamespaceMap();
    private OutputStream output;

    public XMLWriter(OutputStream outputStream, boolean prettyPrint, String encoding) throws UnsupportedEncodingException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding(encoding);
        this.output = outputStream;
        this.dom4jWriter = new org.dom4j.io.XMLWriter(outputStream, format);
    }

    public void startDocument() {
        try {
            this.dom4jWriter.startDocument();
        }
        catch (SAXException sAXException) {}
    }

    public void startElement(QName name) {
        this.startElement(name, null);
    }

    public void startElement(QName name, Attributes attrs) {
        if (attrs == null) {
            attrs = EMPTY_ATTRIBUTES;
        }
        try {
            this.dom4jWriter.startElement(name.getNamespaceURI(), name.getLocalName(), name.toPrefixString((NamespacePrefixResolver)this.prefixResolver), attrs);
        }
        catch (SAXException sAXException) {}
    }

    public void endElement(QName name) {
        try {
            this.dom4jWriter.endElement(name.getNamespaceURI(), name.getLocalName(), name.toPrefixString((NamespacePrefixResolver)this.prefixResolver));
        }
        catch (SAXException sAXException) {}
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixResolver.map(prefix, uri);
        try {
            this.dom4jWriter.startPrefixMapping(prefix, uri);
        }
        catch (SAXException sAXException) {}
    }

    public void endPrefixMapping(String prefix) {
        this.prefixResolver.unmap(prefix);
        try {
            this.dom4jWriter.endPrefixMapping(prefix);
        }
        catch (SAXException sAXException) {}
    }

    public void endDocument() {
        try {
            for (String prefix : this.prefixResolver.getPrefixes()) {
                this.endPrefixMapping(prefix);
            }
            this.dom4jWriter.endDocument();
        }
        catch (SAXException sAXException) {}
    }

    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }

    public void addAttribute(AttributesImpl attrs, QName name, String value) {
        attrs.addAttribute(name.getNamespaceURI(), name.getLocalName(), name.toPrefixString((NamespacePrefixResolver)this.prefixResolver), "String", value);
    }

    public void addAttribute(AttributesImpl attrs, QName name, int value) {
        attrs.addAttribute(name.getNamespaceURI(), name.getLocalName(), name.toPrefixString((NamespacePrefixResolver)this.prefixResolver), "int", Integer.toString(value));
    }

    private static class NamespaceMap
    implements NamespacePrefixResolver {
        private Map<String, Set<String>> uriToPrefixesMap = new TreeMap<String, Set<String>>();
        private Map<String, String> prefixToUriMap = new TreeMap<String, String>();

        private NamespaceMap() {
        }

        public void map(String prefix, String uri) {
            Set<String> prefixes = this.uriToPrefixesMap.get(uri);
            if (prefixes == null) {
                prefixes = new TreeSet<String>();
                this.uriToPrefixesMap.put(uri, prefixes);
            }
            prefixes.add(prefix);
            this.prefixToUriMap.put(prefix, uri);
        }

        public void unmap(String prefix) {
            String uri = this.prefixToUriMap.remove(prefix);
            if (uri != null) {
                this.uriToPrefixesMap.get(uri).remove(prefix);
            }
        }

        public Collection<String> getURIs() {
            return this.uriToPrefixesMap.keySet();
        }

        public Collection<String> getPrefixes() {
            return this.prefixToUriMap.keySet();
        }

        public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
            return Collections.unmodifiableCollection((Collection)this.uriToPrefixesMap.get(namespaceURI));
        }

        public String getNamespaceURI(String prefix) throws NamespaceException {
            return this.prefixToUriMap.get(prefix);
        }
    }
}

