/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.alfresco.repo.workflow.WorkflowAuthorityManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.activiti.ActivitiTaskPropertyHandler;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class ActivitiPooledActorsPropertyHandler
extends ActivitiTaskPropertyHandler {
    private TaskService taskService;
    private WorkflowAuthorityManager authorityManager;

    @Override
    protected Object handleTaskProperty(Task task, TypeDefinition type, QName key, Serializable value) {
        List links = this.taskService.getIdentityLinksForTask(task.getId());
        UserAndGroupUpdates updates = this.getUserAndGroupUpdates(value, links);
        this.updateTaskCandidates(task.getId(), updates);
        return "*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*";
    }

    @Override
    protected Object handleDelegateTaskProperty(DelegateTask task, TypeDefinition type, QName key, Serializable value) {
        List links = ((TaskEntity)task).getIdentityLinks();
        UserAndGroupUpdates updates = this.getUserAndGroupUpdates(value, links);
        this.updateTaskCandidates(task, updates);
        return "*\u00a3$DO NOT ADD THIS PROPERTY $\u00a3*";
    }

    private Collection<NodeRef> getNodes(Serializable value) {
        if (value instanceof Collection) {
            return (Collection)((Object)value);
        }
        if (value instanceof NodeRef) {
            return Collections.singletonList((NodeRef)value);
        }
        throw this.getInvalidPropertyValueException(WorkflowModel.ASSOC_POOLED_ACTORS, value);
    }

    private void updateTaskCandidates(String taskId, UserAndGroupUpdates updates) {
        for (String user : updates.getUsers()) {
            this.taskService.addCandidateUser(taskId, user);
        }
        for (String group : updates.getGroups()) {
            this.taskService.addCandidateGroup(taskId, group);
        }
        for (IdentityLink link : updates.getLinksToRemove()) {
            if (link.getUserId() != null) {
                this.taskService.deleteUserIdentityLink(link.getTaskId(), link.getUserId(), link.getType());
                continue;
            }
            this.taskService.deleteGroupIdentityLink(link.getTaskId(), link.getGroupId(), link.getType());
        }
    }

    private void updateTaskCandidates(DelegateTask task, UserAndGroupUpdates updates) {
        for (String user : updates.getUsers()) {
            task.addCandidateUser(user);
        }
        for (String group : updates.getGroups()) {
            task.addCandidateGroup(group);
        }
        for (IdentityLink link : updates.linksToRemove) {
            if (link.getUserId() != null) {
                task.deleteUserIdentityLink(link.getUserId(), link.getType());
                continue;
            }
            task.deleteGroupIdentityLink(link.getGroupId(), link.getType());
        }
    }

    private UserAndGroupUpdates getUserAndGroupUpdates(Serializable value, Collection<? extends IdentityLink> links) {
        Collection<NodeRef> actors = this.getNodes(value);
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        for (NodeRef actor : actors) {
            String authorityName = this.authorityManager.getAuthorityName(actor);
            ArrayList<String> pooledAuthorities = this.authorityManager.isUser(authorityName) ? users : groups;
            pooledAuthorities.add(authorityName);
        }
        LinkedList<IdentityLink> linksToRemove = new LinkedList<IdentityLink>();
        for (IdentityLink identityLink : links) {
            if (!"candidate".equals(identityLink.getType())) continue;
            String userId = identityLink.getUserId();
            if (userId != null) {
                if (users.remove(userId)) continue;
                linksToRemove.add(identityLink);
                continue;
            }
            String groupId = identityLink.getGroupId();
            if (groupId == null || groups.remove(groupId)) continue;
            linksToRemove.add(identityLink);
        }
        return new UserAndGroupUpdates(users, groups, linksToRemove);
    }

    @Override
    protected QName getKey() {
        return WorkflowModel.ASSOC_POOLED_ACTORS;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setWorkflowAuthorityManager(WorkflowAuthorityManager authorityManager) {
        this.authorityManager = authorityManager;
    }

    private static class UserAndGroupUpdates {
        private final List<String> users;
        private final List<String> groups;
        private final List<IdentityLink> linksToRemove;

        public UserAndGroupUpdates(List<String> users, List<String> groups, List<IdentityLink> linksToRemove) {
            this.users = users;
            this.groups = groups;
            this.linksToRemove = linksToRemove;
        }

        public List<String> getUsers() {
            return this.users;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public List<IdentityLink> getLinksToRemove() {
            return this.linksToRemove;
        }
    }
}

