/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.importfilters;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.bulkimport.ImportFilter;
import org.alfresco.repo.bulkimport.ImportableItem;

public class AndImportFilter
implements ImportFilter {
    private final List<ImportFilter> filters;

    public AndImportFilter(ImportFilter left, ImportFilter right) {
        assert (left != null) : "left must not be null.";
        assert (right != null) : "right must not be null.";
        this.filters = new ArrayList<ImportFilter>(2);
        this.filters.add(left);
        this.filters.add(right);
    }

    public AndImportFilter(List<ImportFilter> filters) {
        assert (filters != null) : "filters must not be null.";
        assert (filters.size() >= 2) : "filters must contain at least 2 items.";
        this.filters = filters;
    }

    @Override
    public boolean shouldFilter(ImportableItem importableItem) {
        boolean result = true;
        for (ImportFilter sourceFilter : this.filters) {
            if (sourceFilter.shouldFilter(importableItem)) continue;
            result = false;
            break;
        }
        return result;
    }
}

