/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.calendar;

import java.util.HashMap;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.Stack;
import org.alfresco.service.cmr.calendar.CalendarRecurrenceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarTimezoneHelper {
    private static Log logger = LogFactory.getLog(CalendarTimezoneHelper.class);
    private static final String ICAL_SECTION_EVENT = "VEVENT";
    private static final String ICAL_SECTION_TIMEZONE = "VTIMEZONE";
    private static final String ICAL_SECTION_TZ_STANDARD = "STANDARD";
    private static final String ICAL_SECTION_TZ_DAYLIGHT = "DAYLIGHT";

    public static SimpleTimeZone buildTimeZone(String ical) {
        return CalendarTimezoneHelper.buildTimeZone(CalendarTimezoneHelper.getICalParams(ical));
    }

    protected static SimpleTimeZone buildTimeZone(Map<String, String> icalParams) {
        HashMap<String, String> tzCore = new HashMap<String, String>();
        HashMap tzStandard = new HashMap();
        HashMap tzDaylight = new HashMap();
        for (String key : icalParams.keySet()) {
            if (!key.startsWith("TZ-")) continue;
            String value = icalParams.get(key);
            key = key.substring(3);
            HashMap<String, String> dst = tzCore;
            if (key.startsWith(ICAL_SECTION_TZ_STANDARD)) {
                dst = tzStandard;
                key = key.substring(ICAL_SECTION_TZ_STANDARD.length() + 1);
            } else if (key.startsWith(ICAL_SECTION_TZ_DAYLIGHT)) {
                dst = tzDaylight;
                key = key.substring(ICAL_SECTION_TZ_DAYLIGHT.length() + 1);
            }
            dst.put(key, value);
        }
        if (tzStandard.isEmpty() && tzDaylight.isEmpty()) {
            logger.warn((Object)("No Standard/Daylight info found for " + String.valueOf(tzCore)));
            return null;
        }
        String tzID = (String)tzCore.get("TZID");
        if (tzID == null || tzID.isEmpty()) {
            tzID = "(unknown)";
        }
        tzID = tzID.replace("\\,", ",");
        if (tzDaylight.isEmpty()) {
            int offset = CalendarTimezoneHelper.getOffset((String)tzStandard.get("TZOFFSETTO"));
            return new SimpleTimeZone(offset, tzID);
        }
        int stdOffset = CalendarTimezoneHelper.getOffset((String)tzDaylight.get("TZOFFSETFROM"));
        CalendarTimezoneHelper.getOffset((String)tzDaylight.get("TZOFFSETTO"));
        int[] stdRules = CalendarTimezoneHelper.getRuleForSimpleTimeZone((String)tzStandard.get("RRULE"));
        int[] dstRules = CalendarTimezoneHelper.getRuleForSimpleTimeZone((String)tzDaylight.get("RRULE"));
        return new SimpleTimeZone(stdOffset, tzID, dstRules[0], dstRules[1], dstRules[2], 3600000, stdRules[0], stdRules[1], stdRules[2], 0x6DDD00);
    }

    private static int getOffset(String tzOffset) {
        int sign = 1;
        if (tzOffset.startsWith("+")) {
            sign = 1;
            tzOffset = tzOffset.substring(1);
        } else if (tzOffset.startsWith("-")) {
            sign = -1;
            tzOffset = tzOffset.substring(1);
        }
        int mins = Integer.parseInt(tzOffset.substring(tzOffset.length() - 2));
        int hours = Integer.parseInt(tzOffset.substring(0, tzOffset.length() - 2));
        int offset = (hours * 60 + mins) * 60 * 1000;
        return offset *= sign;
    }

    private static int[] getRuleForSimpleTimeZone(String rule) {
        HashMap<String, String> params = new HashMap<String, String>();
        String[] stringArray = rule.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            int splitAt = p.indexOf(61);
            if (splitAt == -1) {
                logger.info((Object)("Skipping invalid param " + p + " in recurrence rule " + rule));
            } else {
                params.put(p.substring(0, splitAt), p.substring(splitAt + 1));
            }
            ++n2;
        }
        int month = Integer.parseInt((String)params.get("BYMONTH")) - 1;
        String byDay = (String)params.get("BYDAY");
        String dow = byDay.substring(byDay.length() - 2);
        int dayOfWeek = CalendarRecurrenceHelper.d2cd.get(dow);
        int dayOfMonth = 0;
        if (byDay.startsWith("-1")) {
            dayOfMonth = -1;
        } else if (byDay.startsWith("1")) {
            dayOfMonth = 1;
            dayOfWeek = 0 - dayOfWeek;
        } else {
            dayOfMonth = 1 + (Integer.parseInt(byDay.substring(0, 1)) - 1) * 7;
            dayOfWeek = 0 - dayOfWeek;
        }
        return new int[]{month, dayOfMonth, dayOfWeek};
    }

    protected static String[] icalLineKeyValue(String icalLine) {
        int delim = CalendarTimezoneHelper.indexOfFirstUnquotedColon(icalLine);
        if (delim == -1) {
            return new String[]{"", ""};
        }
        String key = icalLine.substring(0, delim);
        String value = icalLine.substring(delim + 1);
        return new String[]{key, value};
    }

    private static int indexOfFirstUnquotedColon(String icalLine) {
        int colon = icalLine.indexOf(":");
        int quote = icalLine.indexOf("\"");
        if (quote == -1) {
            return colon;
        }
        if (colon < quote) {
            return colon;
        }
        int nextQuote = icalLine.indexOf("\"", quote + 1);
        if (nextQuote == -1) {
            return -1;
        }
        return nextQuote + CalendarTimezoneHelper.indexOfFirstUnquotedColon(icalLine.substring(nextQuote + 1, icalLine.length())) + 1;
    }

    protected static Map<String, String> getICalParams(String icalText) {
        String[] segregatedLines = icalText.split("\r\n");
        if (segregatedLines.length == 1 && icalText.indexOf(10) > 0) {
            segregatedLines = icalText.split("\n");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int attendeeNum = 0;
        Stack<String> stack = new Stack<String>();
        String[] stringArray = segregatedLines;
        int n = segregatedLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] keyValue = CalendarTimezoneHelper.icalLineKeyValue(line);
            if (keyValue.length >= 2) {
                if (keyValue[0].equals("BEGIN")) {
                    stack.push(keyValue[1]);
                } else if (keyValue[0].equals("END")) {
                    stack.pop();
                } else {
                    if (!stack.isEmpty() && ((String)stack.peek()).equals(ICAL_SECTION_EVENT)) {
                        if (keyValue[0].contains(";")) {
                            int splitAt = keyValue[0].indexOf(59);
                            String mainKey = keyValue[0].substring(0, splitAt);
                            if (splitAt < keyValue[0].length() - 2) {
                                String[] extras;
                                String[] stringArray2 = extras = keyValue[0].substring(splitAt + 1).split(";");
                                int n3 = extras.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String extra = stringArray2[n4];
                                    splitAt = extra.indexOf(61);
                                    if (splitAt > -1 && !result.containsKey(mainKey + "-" + extra.substring(0, splitAt - 1))) {
                                        result.put(mainKey + "-" + extra.substring(0, splitAt - 1), extra.substring(splitAt + 1));
                                    }
                                    ++n4;
                                }
                            }
                            keyValue[0] = mainKey;
                        }
                        if (keyValue[0].equals("ATTENDEE")) {
                            keyValue[0] = keyValue[0] + attendeeNum;
                            ++attendeeNum;
                        }
                        if (!result.containsKey(keyValue[0])) {
                            result.put(keyValue[0], keyValue[keyValue.length - 1]);
                        }
                    }
                    if (!stack.isEmpty() && ((String)stack.peek()).equals(ICAL_SECTION_TIMEZONE) && !result.containsKey("TZ-" + keyValue[0])) {
                        result.put("TZ-" + keyValue[0], keyValue[keyValue.length - 1]);
                    }
                    if (stack.size() >= 2 && ((String)stack.get(stack.size() - 2)).equals(ICAL_SECTION_TIMEZONE) && (((String)stack.peek()).equals(ICAL_SECTION_TZ_STANDARD) || ((String)stack.peek()).equals(ICAL_SECTION_TZ_DAYLIGHT)) && !result.containsKey("TZ-" + (String)stack.peek() + "-" + keyValue[0])) {
                        result.put("TZ-" + (String)stack.peek() + "-" + keyValue[0], keyValue[keyValue.length - 1]);
                    }
                }
            }
            ++n2;
        }
        return result;
    }
}

