/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.AbstractJSONAPIResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrActionAclTxReportResult
extends AbstractJSONAPIResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrActionAclTxReportResult.class);

    public SolrActionAclTxReportResult(JSONObject json) {
        try {
            this.processJson(json);
        }
        catch (NullPointerException | JSONException e) {
            LOGGER.info(e.getMessage());
        }
    }

    @Override
    protected void processCoresInfoJson(JSONObject json) throws JSONException {
        ArrayList<String> cores = new ArrayList<String>();
        HashMap coresInfo = new HashMap();
        if (json.has("report")) {
            JSONObject coreList = json.getJSONObject("report");
            JSONArray coreNameList = coreList.names();
            int i = 0;
            while (i < coreNameList.length()) {
                String coreName = String.valueOf(coreNameList.get(i));
                JSONObject core = coreList.getJSONObject(coreName);
                cores.add(coreName);
                HashMap coreInfo = new HashMap();
                JSONObject nodes = core.getJSONObject("nodes");
                HashMap<String, Map<String, Object>> nodesInfo = new HashMap<String, Map<String, Object>>();
                JSONArray nodesPropertyNameList = nodes.names();
                int j = 0;
                while (j < nodesPropertyNameList.length()) {
                    String nodeName = String.valueOf(nodesPropertyNameList.get(j));
                    JSONObject node = nodes.getJSONObject(nodeName);
                    nodesInfo.put(nodeName, this.getPropertyValueMap(node));
                    ++j;
                }
                coreInfo.put("nodes", nodesInfo);
                coresInfo.put(coreName, coreInfo);
                ++i;
            }
        }
        this.cores = cores;
        this.coresInfo = coresInfo;
    }
}

