/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.version;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.namespace.QName;

@AlfrescoPublicApi
public interface VersionService {
    public static final String VERSION_STORE_PROTOCOL = "versionStore";

    @Auditable
    public StoreRef getVersionStoreReference();

    @Auditable
    public boolean isAVersion(NodeRef var1);

    @Auditable
    public boolean isVersioned(NodeRef var1);

    @Auditable(parameters={"nodeRef", "versionProperties"})
    public Version createVersion(NodeRef var1, Map<String, Serializable> var2) throws ReservedVersionNameException, AspectMissingException;

    @Auditable(parameters={"nodeRef", "versionProperties", "versionChildren"})
    public Collection<Version> createVersion(NodeRef var1, Map<String, Serializable> var2, boolean var3) throws ReservedVersionNameException, AspectMissingException;

    @Auditable(parameters={"nodeRef", "versionProperties"})
    public Collection<Version> createVersion(Collection<NodeRef> var1, Map<String, Serializable> var2) throws ReservedVersionNameException, AspectMissingException;

    @Auditable(parameters={"nodeRef"})
    public VersionHistory getVersionHistory(NodeRef var1) throws AspectMissingException;

    @Auditable(parameters={"nodeRef", "skipVersions", "maxVersions"})
    public Optional<VersionHistory> getVersionHistory(NodeRef var1, int var2, int var3) throws AspectMissingException;

    @Auditable(parameters={"nodeRef"})
    public Version getCurrentVersion(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public void revert(NodeRef var1);

    @Auditable(parameters={"nodeRef", "deep"})
    public void revert(NodeRef var1, boolean var2);

    @Auditable(parameters={"nodeRef", "version"})
    public void revert(NodeRef var1, Version var2);

    @Auditable(parameters={"nodeRef", "version", "deep"})
    public void revert(NodeRef var1, Version var2, boolean var3);

    @Auditable(parameters={"nodeRef", "parentNodeRef", "assocTypeQName", "assocQName"})
    public NodeRef restore(NodeRef var1, NodeRef var2, QName var3, QName var4);

    @Auditable(parameters={"nodeRef", "parentNodeRef", "assocTypeQName", "assocQName", "deep"})
    public NodeRef restore(NodeRef var1, NodeRef var2, QName var3, QName var4, boolean var5);

    @Auditable(parameters={"nodeRef"})
    public void deleteVersionHistory(NodeRef var1) throws AspectMissingException;

    @Auditable(parameters={"nodeRef", "version"})
    public void deleteVersion(NodeRef var1, Version var2);

    @Auditable(parameters={"nodeRef"})
    public void ensureVersioningEnabled(NodeRef var1, Map<QName, Serializable> var2);

    public void registerVersionLabelPolicy(QName var1, VersionServicePolicies.CalculateVersionLabelPolicy var2);
}

