/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;

public class SimpleAcceptOrRejectAllAuthenticationComponentImpl
extends AbstractAuthenticationComponent {
    private boolean accept = false;
    private AuthenticationDao authenticationDao;

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void setAccept(boolean accept) {
        this.accept = accept;
    }

    @Override
    public void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        if (!this.accept) {
            throw new AuthenticationException("Access Denied");
        }
        this.setCurrentUser(userName);
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return this.accept;
    }

    public String getMD4HashedPassword(String userName) {
        if (this.accept) {
            return "0cb6948805f797bf2a82807973b89537";
        }
        throw new AuthenticationException("Access Denied");
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        throw new AlfrescoRuntimeException("Authentication via token not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected UserDetails getUserDetails(String userName) {
        UserDetails userDetails = null;
        if (AuthenticationUtil.isMtEnabled()) {
            Authentication originalFullAuthentication = AuthenticationUtil.getFullAuthentication();
            try {
                try {
                    if (originalFullAuthentication == null) {
                        AuthenticationUtil.setFullyAuthenticatedUser((String)this.getSystemUserName(this.getUserDomain(userName)));
                    }
                    userDetails = this.authenticationDao.loadUserByUsername(userName);
                    return userDetails;
                }
                catch (UsernameNotFoundException usernameNotFoundException) {
                    this.logEvent(userName);
                    userDetails = super.getUserDetails(userName);
                    if (originalFullAuthentication != null) return userDetails;
                    ContextHolder.setContext(null);
                }
                return userDetails;
            }
            finally {
                if (originalFullAuthentication == null) {
                    ContextHolder.setContext(null);
                }
            }
        } else {
            try {
                return this.authenticationDao.loadUserByUsername(userName);
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
                this.logEvent(userName);
                return super.getUserDetails(userName);
            }
        }
    }

    private void logEvent(String userName) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("The user was not created beforehand: " + AuthenticationUtil.maskUsername((String)userName) + " . This is not a problem, we expect this to happen in some cases"));
        }
    }
}

