/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ClasspathScriptLocation
implements ScriptLocation {
    private final String location;

    public ClasspathScriptLocation(String location) {
        ParameterCheck.mandatory((String)"Location", (Object)location);
        this.location = location;
    }

    @Override
    public InputStream getInputStream() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.location);
        if (stream == null) {
            throw new AlfrescoRuntimeException("Unable to load classpath resource: " + this.location);
        }
        return stream;
    }

    @Override
    public Reader getReader() {
        InputStreamReader reader = null;
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.location);
            if (stream == null) {
                throw new AlfrescoRuntimeException("Unable to load classpath resource: " + this.location);
            }
            reader = new InputStreamReader(stream);
        }
        catch (Throwable err) {
            throw new ScriptException("Failed to load classpath resource '" + this.location + "': " + err.getMessage(), err);
        }
        return reader;
    }

    @Override
    public String getPath() {
        return this.location;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ClasspathScriptLocation)) {
            return false;
        }
        ClasspathScriptLocation other = (ClasspathScriptLocation)obj;
        return this.location.equals(other.location);
    }

    public int hashCode() {
        return 37 * this.location.hashCode();
    }

    public String toString() {
        return this.location.toString();
    }
}

