/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Category(value={OwnJVMTestsCategory.class})
public class TemporaryNodesTest {
    private static final String SITE_SHORT_NAME = "siteShortName" + TemporaryNodesTest.class.getSimpleName() + UUID.randomUUID().toString();
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserOne");
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserTwo");
    public static TemporaryNodes STATIC_TEST_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1).around((TestRule)TEST_USER2).around((TestRule)STATIC_TEST_NODES);
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    @Rule
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    private static CheckOutCheckInService COCI_SERVICE;
    private static ContentService CONTENT_SERVICE;
    private static NodeService NODE_SERVICE;
    private static SiteService SITE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static VersionService VERSION_SERVICE;
    private static NodeRef COMPANY_HOME;
    private NodeRef testNode1;
    private NodeRef testNode2;

    @BeforeClass
    public static void initStaticData() throws Exception {
        COCI_SERVICE = (CheckOutCheckInService)APP_CONTEXT_INIT.getApplicationContext().getBean("checkOutCheckInService", CheckOutCheckInService.class);
        CONTENT_SERVICE = (ContentService)APP_CONTEXT_INIT.getApplicationContext().getBean("ContentService", ContentService.class);
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService", NodeService.class);
        SITE_SERVICE = (SiteService)APP_CONTEXT_INIT.getApplicationContext().getBean("SiteService", SiteService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        VERSION_SERVICE = (VersionService)APP_CONTEXT_INIT.getApplicationContext().getBean("VersionService", VersionService.class);
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper", Repository.class);
        COMPANY_HOME = repositoryHelper.getCompanyHome();
    }

    @Before
    public void createTestContent() {
        this.testNode1 = this.testNodes.createNode(COMPANY_HOME, "doc 1", ContentModel.TYPE_CONTENT, TEST_USER1.getUsername());
        this.testNode2 = this.testNodes.createNodeWithTextContent(COMPANY_HOME, "doc 2", ContentModel.TYPE_CONTENT, TEST_USER2.getUsername(), "Hello world");
    }

    @Test
    public void ensureTestNodesWereCreatedOk() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertTrue((String)"Test node does not exist", (boolean)NODE_SERVICE.exists(TemporaryNodesTest.this.testNode1));
                Assert.assertTrue((String)"Test node does not exist", (boolean)NODE_SERVICE.exists(TemporaryNodesTest.this.testNode2));
                Map node1Props = NODE_SERVICE.getProperties(TemporaryNodesTest.this.testNode1);
                Map node2Props = NODE_SERVICE.getProperties(TemporaryNodesTest.this.testNode2);
                Assert.assertEquals((String)"cm:name was wrong", (Object)"doc 1", node1Props.get(ContentModel.PROP_NAME));
                Assert.assertEquals((String)"cm:name was wrong", (Object)"doc 2", node2Props.get(ContentModel.PROP_NAME));
                Assert.assertEquals((String)"cm:creator was wrong", (Object)TEST_USER1.getUsername(), node1Props.get(ContentModel.PROP_CREATOR));
                Assert.assertEquals((String)"cm:creator was wrong", (Object)TEST_USER2.getUsername(), node2Props.get(ContentModel.PROP_CREATOR));
                ContentReader reader = CONTENT_SERVICE.getReader(TemporaryNodesTest.this.testNode1, ContentModel.PROP_CONTENT);
                Assert.assertNull((String)"Content was unexpectedly present", (Object)reader);
                reader = CONTENT_SERVICE.getReader(TemporaryNodesTest.this.testNode2, ContentModel.PROP_CONTENT);
                Assert.assertEquals((String)"Content was wrong", (Object)"Hello world", (Object)reader.getContentString("Hello world".length()));
                return null;
            }
        });
    }

    @Test
    public void ensureCheckedOutNodesAreCleanedUp() throws Throwable {
        TemporaryNodes myTemporaryNodes = new TemporaryNodes(APP_CONTEXT_INIT);
        myTemporaryNodes.before();
        final ArrayList<NodeRef> nodesThatShouldBeDeletedByRule = new ArrayList<NodeRef>();
        nodesThatShouldBeDeletedByRule.add(myTemporaryNodes.createNode(COMPANY_HOME, "normal node", ContentModel.TYPE_CONTENT, TEST_USER1.getUsername()));
        final NodeRef checkedoutNode = myTemporaryNodes.createNode(COMPANY_HOME, "checkedout node", ContentModel.TYPE_CONTENT, TEST_USER1.getUsername());
        nodesThatShouldBeDeletedByRule.add(checkedoutNode);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef workingCopy = COCI_SERVICE.checkout(checkedoutNode);
                nodesThatShouldBeDeletedByRule.add(workingCopy);
                return null;
            }
        });
        myTemporaryNodes.after();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (NodeRef node : nodesThatShouldBeDeletedByRule) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    Assert.fail((String)("Node '" + String.valueOf(NODE_SERVICE.getProperty(node, ContentModel.PROP_NAME)) + "' still exists."));
                }
                return null;
            }
        });
    }

    @Test
    public void ensureVersionedNodesAreFullyCleanedUp() throws Throwable {
        TemporaryNodes myTemporaryNodes = new TemporaryNodes(APP_CONTEXT_INIT);
        myTemporaryNodes.before();
        final ArrayList<NodeRef> nodesThatShouldBeDeletedByRule = new ArrayList<NodeRef>();
        final NodeRef versionedTempNode = myTemporaryNodes.createQuickFile("text/plain", COMPANY_HOME, "versionableNode", TEST_USER1.getUsername(), true);
        nodesThatShouldBeDeletedByRule.add(versionedTempNode);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertTrue((String)"The test node was not versioned as it should be.", (boolean)VERSION_SERVICE.isVersioned(versionedTempNode));
                Version v1 = VERSION_SERVICE.createVersion(versionedTempNode, null);
                Version v2 = VERSION_SERVICE.createVersion(versionedTempNode, null);
                Version v3 = VERSION_SERVICE.createVersion(versionedTempNode, null);
                Version[] versionArray = new Version[]{v1, v2, v3};
                int n = versionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Version v = versionArray[n2];
                    nodesThatShouldBeDeletedByRule.add(v.getFrozenStateNodeRef());
                    ++n2;
                }
                return null;
            }
        });
        myTemporaryNodes.after();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (NodeRef node : nodesThatShouldBeDeletedByRule) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    Assert.fail((String)("Node '" + String.valueOf(NODE_SERVICE.getProperty(node, ContentModel.PROP_NAME)) + "' still exists."));
                }
                return null;
            }
        });
    }

    @Test
    public void ensureSiteNodesAreCleanedUp() throws Throwable {
        TemporaryNodes myTemporaryNodes = new TemporaryNodes(APP_CONTEXT_INIT);
        myTemporaryNodes.before();
        SiteInfo createdSite = (SiteInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                return SITE_SERVICE.createSite("sitePreset", SITE_SHORT_NAME, "site title", "site description", SiteVisibility.PUBLIC);
            }
        });
        final NodeRef siteNodeRef = createdSite.getNodeRef();
        myTemporaryNodes.addNodeRef(siteNodeRef);
        myTemporaryNodes.after();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (NODE_SERVICE.exists(siteNodeRef)) {
                    Assert.fail((String)("Node '" + String.valueOf(NODE_SERVICE.getProperty(siteNodeRef, ContentModel.PROP_NAME)) + "' still exists."));
                }
                return null;
            }
        });
    }

    @Test
    public void testCreateFolderAndQuickFiles() throws Throwable {
        TemporaryNodes myTemporaryNodes = new TemporaryNodes(APP_CONTEXT_INIT);
        myTemporaryNodes.before();
        final NodeRef folder = myTemporaryNodes.createFolder(COMPANY_HOME, "testFolder", AuthenticationUtil.getAdminUserName());
        final NodeRef quickTxt = myTemporaryNodes.createQuickFile("text/plain", folder, "quickFile", AuthenticationUtil.getAdminUserName());
        final NodeRef namedQuickTxt = myTemporaryNodes.createQuickFileByName("quickCorrupt.jpg", folder, AuthenticationUtil.getAdminUserName());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertTrue((boolean)NODE_SERVICE.exists(folder));
                Assert.assertTrue((boolean)NODE_SERVICE.exists(quickTxt));
                Assert.assertTrue((boolean)NODE_SERVICE.exists(namedQuickTxt));
                Assert.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)NODE_SERVICE.getType(folder));
                Assert.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)NODE_SERVICE.getType(quickTxt));
                Assert.assertEquals((Object)ContentModel.TYPE_CONTENT, (Object)NODE_SERVICE.getType(namedQuickTxt));
                Assert.assertEquals((Object)AuthenticationUtil.getAdminUserName(), (Object)NODE_SERVICE.getProperty(folder, ContentModel.PROP_CREATOR));
                Assert.assertEquals((Object)AuthenticationUtil.getAdminUserName(), (Object)NODE_SERVICE.getProperty(quickTxt, ContentModel.PROP_CREATOR));
                Assert.assertEquals((Object)AuthenticationUtil.getAdminUserName(), (Object)NODE_SERVICE.getProperty(namedQuickTxt, ContentModel.PROP_CREATOR));
                ContentReader reader = CONTENT_SERVICE.getReader(quickTxt, ContentModel.PROP_CONTENT);
                Assert.assertEquals((Object)"text/plain", (Object)reader.getMimetype());
                Assert.assertEquals((long)235L, (long)reader.getSize());
                String content = reader.getContentString();
                Assert.assertTrue((boolean)content.contains("quick brown fox"));
                ContentReader reader2 = CONTENT_SERVICE.getReader(namedQuickTxt, ContentModel.PROP_CONTENT);
                Assert.assertEquals((Object)"image/jpeg", (Object)reader2.getMimetype());
                return null;
            }
        });
        myTemporaryNodes.after();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertFalse((boolean)NODE_SERVICE.exists(folder));
                Assert.assertFalse((boolean)NODE_SERVICE.exists(quickTxt));
                Assert.assertFalse((boolean)NODE_SERVICE.exists(namedQuickTxt));
                return null;
            }
        });
    }
}

