/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.util.Arrays;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.impl.JSONAPIResult;
import org.alfresco.repo.search.impl.solr.SolrActionAclReportResult;
import org.alfresco.repo.search.impl.solr.SolrActionAclTxReportResult;
import org.alfresco.repo.search.impl.solr.SolrActionCheckResult;
import org.alfresco.repo.search.impl.solr.SolrActionFixResult;
import org.alfresco.repo.search.impl.solr.SolrActionNodeReportResult;
import org.alfresco.repo.search.impl.solr.SolrActionReportResult;
import org.alfresco.repo.search.impl.solr.SolrActionStatusResult;
import org.alfresco.repo.search.impl.solr.SolrActionTxReportResult;
import org.json.JSONObject;

public class JSONAPIResultFactory {
    public static JSONAPIResult buildActionResult(ACTION action, JSONObject json) {
        switch (action) {
            case STATUS: {
                return new SolrActionStatusResult(json);
            }
            case REPORT: {
                return new SolrActionReportResult(json);
            }
            case TXREPORT: {
                return new SolrActionTxReportResult(json);
            }
            case ACLTXREPORT: {
                return new SolrActionAclTxReportResult(json);
            }
            case ACLREPORT: {
                return new SolrActionAclReportResult(json);
            }
            case NODEREPORT: {
                return new SolrActionNodeReportResult(json);
            }
            case FIX: {
                return new SolrActionFixResult(json);
            }
            case CHECK: {
                return new SolrActionCheckResult(json);
            }
        }
        throw new AlfrescoRuntimeException("Action " + String.valueOf((Object)action) + " is not supported when invoking to SOLR REST API, available actions: " + String.valueOf(Arrays.asList(ACTION.values())));
    }

    public static enum ACTION {
        STATUS,
        REPORT,
        TXREPORT,
        ACLTXREPORT,
        NODEREPORT,
        ACLREPORT,
        FIX,
        CHECK;

    }

    public static enum COMMAND {
        BACKUP;

    }

    public static enum HANDLER {
        REPLICATION;

    }
}

