/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.processor;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.alfresco.service.cmr.repository.TemplateService;
import org.springframework.extensions.surf.util.I18NUtil;

public class TemplateServiceImpl
implements TemplateService {
    private String defaultTemplateEngine;
    private Map<String, TemplateProcessor> processors = new HashMap<String, TemplateProcessor>(5);
    private Map<String, String> processorNamesByExtension = new HashMap<String, String>(5);
    private NodeService nodeService;

    public void setDefaultTemplateEngine(String defaultTemplateEngine) {
        this.defaultTemplateEngine = defaultTemplateEngine;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public TemplateProcessor getTemplateProcessor(String engine) {
        if (engine == null) {
            engine = this.defaultTemplateEngine;
        }
        return this.processors.get(engine);
    }

    @Override
    public void registerTemplateProcessor(TemplateProcessor templateProcessor) {
        this.processors.put(templateProcessor.getName(), templateProcessor);
        this.processorNamesByExtension.put(templateProcessor.getExtension(), templateProcessor.getName());
    }

    @Override
    public String processTemplate(String template, Object model) throws TemplateException {
        return this.processTemplate(this.getTemplateProcessorName(template), template, model);
    }

    @Override
    public void processTemplate(String template, Object model, Writer out) throws TemplateException {
        this.processTemplate(this.getTemplateProcessorName(template), template, model, out);
    }

    private String getTemplateProcessorName(String template) {
        String engine;
        block4: {
            engine = null;
            try {
                NodeRef templateNodeRef = new NodeRef(template);
                String templateName = (String)((Object)this.nodeService.getProperty(templateNodeRef, ContentModel.PROP_NAME));
                String extension = this.getFileExtension(templateName);
                if (extension != null) {
                    engine = this.processorNamesByExtension.get(extension);
                }
            }
            catch (AlfrescoRuntimeException alfrescoRuntimeException) {
                String extension = this.getFileExtension(template);
                if (extension == null) break block4;
                engine = this.processorNamesByExtension.get(extension);
            }
        }
        if (engine == null) {
            engine = this.defaultTemplateEngine;
        }
        return engine;
    }

    private String getFileExtension(String fileName) {
        String extension = null;
        int index = fileName.lastIndexOf(46);
        if (index > -1 && index < fileName.length() - 1) {
            extension = fileName.substring(index + 1);
        }
        return extension;
    }

    @Override
    public void processTemplate(String engine, String template, Object model, Writer out) throws TemplateException {
        try {
            TemplateProcessor processor = this.getTemplateProcessor(engine);
            processor.process(template, model, out);
        }
        catch (TemplateException terr) {
            throw terr;
        }
        catch (Throwable err) {
            throw new TemplateException(err.getMessage(), err);
        }
    }

    @Override
    public String processTemplate(String engine, String template, Object model, Locale locale) throws TemplateException {
        StringWriter out = new StringWriter(1024);
        this.processTemplate(engine, template, model, out, locale);
        return ((Object)out).toString();
    }

    private void processTemplate(String engine, String template, Object model, Writer out, Locale locale) throws TemplateException {
        Locale currentLocale = I18NUtil.getLocaleOrNull();
        Locale currentContentLocale = I18NUtil.getContentLocaleOrNull();
        try {
            try {
                I18NUtil.setLocale((Locale)locale);
                TemplateProcessor processor = this.getTemplateProcessor(engine);
                processor.process(template, model, out, locale);
            }
            catch (TemplateException terr) {
                throw terr;
            }
            catch (Throwable err) {
                throw new TemplateException(err.getMessage(), err);
            }
        }
        finally {
            I18NUtil.setLocale((Locale)currentLocale);
            I18NUtil.setContentLocale((Locale)currentContentLocale);
        }
    }

    @Override
    public String processTemplate(String engine, String template, Object model) throws TemplateException {
        StringWriter out = new StringWriter(1024);
        this.processTemplate(engine, template, model, out);
        return ((Object)out).toString();
    }

    @Override
    public void processTemplateString(String engine, String template, Object model, Writer out) throws TemplateException {
        try {
            TemplateProcessor processor = this.getTemplateProcessor(engine);
            processor.processString(template, model, out);
        }
        catch (TemplateException terr) {
            throw terr;
        }
        catch (Throwable err) {
            throw new TemplateException(err.getMessage(), err);
        }
    }

    @Override
    public String processTemplateString(String engine, String template, Object model) throws TemplateException {
        StringWriter out = new StringWriter(1024);
        this.processTemplateString(engine, template, model, out);
        return ((Object)out).toString();
    }

    @Override
    public Map<String, Object> buildDefaultModel(NodeRef person, NodeRef companyHome, NodeRef userHome, NodeRef template, TemplateImageResolver imageResolver) {
        HashMap<String, Object> model = new HashMap<String, Object>(16, 1.0f);
        if (imageResolver != null) {
            model.put("imageresolver", imageResolver);
        }
        if (companyHome != null) {
            model.put("companyhome", companyHome);
        }
        if (userHome != null) {
            model.put("userhome", userHome);
        }
        if (person != null) {
            model.put("person", person);
        }
        if (template != null) {
            model.put("template", template);
        }
        model.put("date", new Date());
        return model;
    }
}

