/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.camel.routes;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TransformRequestConsumer
extends RouteBuilder {
    private static Log logger = LogFactory.getLog(TransformRequestConsumer.class);
    @Value(value="${acs.repo.transform.request.endpoint}")
    public String sourceQueue;
    @Autowired
    @Qualifier(value="transformRequestProcessor")
    private Processor processor;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public void setSourceQueue(String sourceQueue) {
        this.sourceQueue = sourceQueue;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public void configure() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Transform Request events route config: ");
            logger.debug((Object)("SourceQueue is " + this.sourceQueue));
        }
        ((ThreadsDefinition)this.from(this.sourceQueue).threads().executorService(this.executorService).process(this.processor)).end();
    }
}

