/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.tenant.Quota;
import org.alfresco.repo.tenant.Tenant;

public class Network
extends Tenant
implements Comparable<Network> {
    protected Date createdAt;
    protected Boolean isHomeNetwork;
    protected List<Quota> quotas = new LinkedList<Quota>();
    protected String subscriptionLevel;
    protected Boolean paidNetwork;

    public Network(String tenantDomain, boolean enabled, String rootContentStoreDir, String dbUrl) {
        super(tenantDomain, enabled, rootContentStoreDir, dbUrl);
    }

    public Network(Tenant tenant, Boolean isHomeNetwork, Date createdAt, String subscriptionLevel, Boolean paidNetwork, List<Quota> quotas) {
        super(tenant.getTenantDomain(), tenant.isEnabled(), tenant.getRootContentStoreDir(), tenant.getDbUrl());
        this.isHomeNetwork = isHomeNetwork;
        this.createdAt = createdAt;
        this.subscriptionLevel = subscriptionLevel;
        this.paidNetwork = paidNetwork;
        this.quotas = quotas;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Boolean getIsHomeNetwork() {
        return this.isHomeNetwork;
    }

    public String getSubscriptionLevel() {
        return this.subscriptionLevel;
    }

    public Boolean getPaidNetwork() {
        return this.paidNetwork;
    }

    public List<Quota> getQuotas() {
        return this.quotas;
    }

    public String toString() {
        return "Network [createdAt=" + String.valueOf(this.createdAt) + ", isHomeNetwork=" + String.valueOf(this.isHomeNetwork) + ", quotas=" + String.valueOf(this.quotas) + ", subscriptionLevel=" + this.subscriptionLevel + ", paidNetwork=" + String.valueOf(this.paidNetwork) + "]";
    }

    @Override
    public int compareTo(Network o) {
        int ret = this.getTenantDomain().compareTo(o.getTenantDomain());
        return ret;
    }
}

