/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.solr.facet.FacetQueryProvider;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SolrFacetHelper {
    private static Log logger = LogFactory.getLog(SolrFacetHelper.class);
    private final Map<String, List<String>> facetQueries;
    private Set<String> specialFacetIds = Collections.emptySet();

    public SolrFacetHelper(List<FacetQueryProvider> facetQueryProviders) {
        PropertyCheck.mandatory((Object)this, (String)"facetQueryProviders", facetQueryProviders);
        this.facetQueries = new LinkedHashMap<String, List<String>>();
        for (FacetQueryProvider queryProvider : facetQueryProviders) {
            for (Map.Entry<String, List<String>> entry : queryProvider.getFacetQueries().entrySet()) {
                this.facetQueries.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setSpecialFacetIds(Set<String> ids) {
        this.specialFacetIds = ids;
    }

    public List<String> getDefaultFacetQueries() {
        Collection<List<String>> queries = this.facetQueries.values();
        ArrayList<String> list = new ArrayList<String>();
        for (List<String> q : queries) {
            list.addAll(q);
        }
        return list;
    }

    public boolean hasFacetQueries(String facetField) {
        return this.facetQueries.containsKey(facetField);
    }

    public List<String> getFacetQueries(String facetField) {
        List<String> queries = this.facetQueries.get(facetField);
        if (queries == null) {
            return null;
        }
        return Collections.unmodifiableList(queries);
    }

    public Set<String> getBucketedFieldFacets() {
        return Collections.unmodifiableSet(this.facetQueries.keySet());
    }

    public String createFacetQueriesFromSearchQuery(String field, String searchQuery) {
        if (field == null) {
            return null;
        }
        try {
            if (field.startsWith("@")) {
                field = field.substring(1);
            }
            String escapedField = searchQuery.substring(searchQuery.indexOf(field));
            String dateRange = escapedField.substring(field.length() + 2, escapedField.indexOf(")")).trim();
            dateRange = dateRange.replace("\"..\"", " TO ");
            dateRange = (dateRange = dateRange.replace("\"", "")) == null ? null : field + ":[" + dateRange + "]";
            return "@" + dateRange;
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn\u2019t extract " + field + " date range from the search query." + String.valueOf(e)));
            return null;
        }
    }

    public boolean isSpecialFacetId(String facetId) {
        return this.specialFacetIds.contains(facetId);
    }
}

