/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.client.config.ClientAppConfig;
import org.alfresco.repo.client.config.ClientAppNotFoundException;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionException;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.quickshare.QuickShareDTO;
import org.alfresco.service.cmr.quickshare.QuickShareDisabledException;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryAction;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryActionPersister;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.events.types.ActivityEvent;
import org.alfresco.sync.events.types.Event;
import org.alfresco.sync.repo.Client;
import org.alfresco.sync.repo.events.EventPreparator;
import org.alfresco.sync.repo.events.EventPublisher;
import org.alfresco.util.EmailHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class QuickShareServiceImpl
implements QuickShareService,
NodeServicePolicies.BeforeDeleteNodePolicy,
CopyServicePolicies.OnCopyNodePolicy,
NodeServicePolicies.OnRestoreNodePolicy {
    private static final Log logger = LogFactory.getLog(QuickShareServiceImpl.class);
    static final String ATTR_KEY_SHAREDIDS_ROOT = ".sharedIds";
    private static final String FTL_SHARED_NODE_URL = "shared_node_url";
    private static final String FTL_SHARED_NODE_NAME = "shared_node_name";
    private static final String FTL_SENDER_MESSAGE = "sender_message";
    private static final String FTL_SENDER_FIRST_NAME = "sender_first_name";
    private static final String FTL_SENDER_LAST_NAME = "sender_last_name";
    private static final String FTL_TEMPLATE_ASSETS_URL = "template_assets_url";
    private static final String CONFIG_SHARED_LINK_BASE_URL = "sharedLinkBaseUrl";
    private static final String DEFAULT_EMAIL_SUBJECT = "quickshare.notifier.email.subject";
    private static final String EMAIL_TEMPLATE_REF = "alfresco/templates/quickshare-email-templates/quickshare-email.default.template.ftl";
    private AttributeService attributeService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private PersonService personService;
    private PolicyComponent policyComponent;
    private TenantService tenantService;
    private ThumbnailService thumbnailService;
    private EventPublisher eventPublisher;
    private ActionService actionService;
    private BehaviourFilter behaviourFilter;
    private SearchService searchService;
    private SiteService siteService;
    private AuthorityService authorityService;
    private SysAdminParams sysAdminParams;
    private EmailHelper emailHelper;
    private boolean enabled;
    private String defaultEmailSender;
    private ClientAppConfig clientAppConfig;
    private ScheduledPersistedActionService scheduledPersistedActionService;
    private QuickShareLinkExpiryActionPersister quickShareLinkExpiryActionPersister;
    private ExpiryDatePeriod expiryDatePeriod = ExpiryDatePeriod.DAYS;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDefaultEmailSender(String defaultEmailSender) {
        this.defaultEmailSender = defaultEmailSender;
    }

    public void setClientAppConfig(ClientAppConfig clientAppConfig) {
        this.clientAppConfig = clientAppConfig;
    }

    public void setScheduledPersistedActionService(ScheduledPersistedActionService scheduledPersistedActionService) {
        this.scheduledPersistedActionService = scheduledPersistedActionService;
    }

    public void setQuickShareLinkExpiryActionPersister(QuickShareLinkExpiryActionPersister quickShareLinkExpiryActionPersister) {
        this.quickShareLinkExpiryActionPersister = quickShareLinkExpiryActionPersister;
    }

    public void setExpiryDatePeriod(String expiryDatePeriod) {
        if (expiryDatePeriod != null) {
            this.expiryDatePeriod = ExpiryDatePeriod.valueOf(expiryDatePeriod.toUpperCase());
        }
    }

    private void checkMandatoryProperties() {
        PropertyCheck.mandatory((Object)this, (String)"attributeService", (Object)this.attributeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"personService", (Object)this.personService);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"thumbnailService", (Object)this.thumbnailService);
        PropertyCheck.mandatory((Object)this, (String)"eventPublisher", (Object)this.eventPublisher);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"defaultEmailSender", (Object)this.defaultEmailSender);
        PropertyCheck.mandatory((Object)this, (String)"clientAppConfig", (Object)((Object)this.clientAppConfig));
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"siteService", (Object)this.siteService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"sysAdminParams", (Object)this.sysAdminParams);
        PropertyCheck.mandatory((Object)this, (String)"emailHelper", (Object)this.emailHelper);
        PropertyCheck.mandatory((Object)this, (String)"scheduledPersistedActionService", (Object)this.scheduledPersistedActionService);
        PropertyCheck.mandatory((Object)this, (String)"quickShareLinkExpiryActionPersister", (Object)this.quickShareLinkExpiryActionPersister);
    }

    public void init() {
        this.checkMandatoryProperties();
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, QuickShareModel.ASPECT_QSHARE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRestoreNodePolicy.QNAME, QuickShareModel.ASPECT_QSHARE, (Behaviour)new JavaBehaviour(this, "onRestoreNode"));
    }

    @Override
    public QuickShareDTO shareContent(NodeRef nodeRef) {
        return this.shareContent(nodeRef, null);
    }

    @Override
    public QuickShareDTO shareContent(final NodeRef nodeRef, Date expiryDate) throws QuickShareDisabledException, InvalidNodeRefException {
        String sharedId;
        this.checkEnabled();
        final QName typeQName = this.nodeService.getType(nodeRef);
        if (!this.isSharable(typeQName)) {
            throw new InvalidNodeRefException(nodeRef);
        }
        if (!this.nodeService.getAspects(nodeRef).contains(QuickShareModel.ASPECT_QSHARE)) {
            UUID uuid = Generators.randomBasedGenerator().generate();
            sharedId = Base64.encodeBase64URLSafeString((byte[])UUIDUtil.asByteArray((UUID)uuid));
            final HashMap<QName, String> props = new HashMap<QName, String>(2);
            props.put(QuickShareModel.PROP_QSHARE_SHAREDID, sharedId);
            props.put(QuickShareModel.PROP_QSHARE_SHAREDBY, AuthenticationUtil.getRunAsUser());
            this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            try {
                AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() {
                        QuickShareServiceImpl.this.nodeService.addAspect(nodeRef, QuickShareModel.ASPECT_QSHARE, props);
                        return null;
                    }
                });
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
            final NodeRef tenantNodeRef = this.tenantService.getName(nodeRef);
            TenantUtil.runAsDefaultTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    QuickShareServiceImpl.this.attributeService.setAttribute((Serializable)tenantNodeRef, new Serializable[]{QuickShareServiceImpl.ATTR_KEY_SHAREDIDS_ROOT, sharedId});
                    return null;
                }
            });
            final StringBuffer sb = new StringBuffer();
            sb.append("{").append("\"sharedId\":\"").append(sharedId).append("\"").append("}");
            this.eventPublisher.publishEvent(new EventPreparator(){

                public Event prepareEvent(String user, String networkId, String transactionId) {
                    return new ActivityEvent("quickshare", transactionId, networkId, user, nodeRef.getId(), null, typeQName.toString(), Client.asType((Client.ClientType)Client.ClientType.webclient), sb.toString(), null, null, 0L, null);
                }
            });
            if (logger.isInfoEnabled()) {
                logger.info((Object)("QuickShare - shared content: " + sharedId + " [" + String.valueOf(nodeRef) + "]"));
            }
        } else {
            sharedId = (String)((Object)this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("QuickShare - content already shared: " + sharedId + " [" + String.valueOf(nodeRef) + "]"));
            }
        }
        if (expiryDate != null) {
            AuthenticationUtil.runAsSystem(() -> {
                this.saveSharedLinkExpiryAction(sharedId, expiryDate);
                this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                try {
                    this.nodeService.setProperty(nodeRef, QuickShareModel.PROP_QSHARE_EXPIRY_DATE, (Serializable)expiryDate);
                }
                finally {
                    this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                }
                return null;
            });
        }
        return new QuickShareDTO(sharedId, expiryDate);
    }

    private void checkEnabled() {
        if (!this.enabled) {
            throw new QuickShareDisabledException("QuickShare is disabled system-wide");
        }
    }

    @Override
    public Map<String, Object> getMetaData(NodeRef nodeRef) {
        Map personProps;
        ContentData contentData;
        Map nodeProps;
        block12: {
            nodeProps = this.nodeService.getProperties(nodeRef);
            contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
            String modifierUserName = (String)nodeProps.get(ContentModel.PROP_MODIFIER);
            personProps = null;
            if (modifierUserName != null) {
                try {
                    NodeRef personRef = this.personService.getPerson(modifierUserName);
                    if (personRef != null) {
                        personProps = this.nodeService.getProperties(personRef);
                    }
                }
                catch (NoSuchPersonException noSuchPersonException) {
                    if (!logger.isInfoEnabled()) break block12;
                    logger.info((Object)("MetaDataGet - no such person: " + modifierUserName));
                }
            }
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>(8);
        metadata.put("nodeRef", nodeRef.toString());
        metadata.put("name", nodeProps.get(ContentModel.PROP_NAME));
        metadata.put("title", nodeProps.get(ContentModel.PROP_TITLE));
        metadata.put("description", nodeProps.get(ContentModel.PROP_DESCRIPTION));
        if (contentData != null) {
            metadata.put("mimetype", contentData.getMimetype());
            metadata.put("size", contentData.getSize());
        } else {
            metadata.put("size", 0L);
        }
        metadata.put("modified", nodeProps.get(ContentModel.PROP_MODIFIED));
        if (personProps != null) {
            metadata.put("modifierFirstName", personProps.get(ContentModel.PROP_FIRSTNAME));
            metadata.put("modifierLastName", personProps.get(ContentModel.PROP_LASTNAME));
        }
        ArrayList<String> thumbnailDefs = new ArrayList<String>(7);
        if (contentData != null) {
            List<ThumbnailDefinition> thumbnailDefinitions = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinitions(contentData.getMimetype(), contentData.getSize());
            for (ThumbnailDefinition thumbnailDefinition : thumbnailDefinitions) {
                thumbnailDefs.add(thumbnailDefinition.getName());
            }
        }
        metadata.put("thumbnailDefinitions", thumbnailDefs);
        List<NodeRef> thumbnailRefs = this.thumbnailService.getThumbnails(nodeRef, ContentModel.PROP_CONTENT, null, null);
        ArrayList<String> thumbnailNames = new ArrayList<String>(thumbnailRefs.size());
        for (NodeRef thumbnailRef : thumbnailRefs) {
            thumbnailNames.add((String)((Object)this.nodeService.getProperty(thumbnailRef, ContentModel.PROP_NAME)));
        }
        metadata.put("thumbnailNames", thumbnailNames);
        metadata.put("lastThumbnailModificationData", (List)nodeProps.get(ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
        if (nodeProps.containsKey(QuickShareModel.PROP_QSHARE_SHAREDID)) {
            metadata.put("sharedId", nodeProps.get(QuickShareModel.PROP_QSHARE_SHAREDID));
            metadata.put("expiryDate", nodeProps.get(QuickShareModel.PROP_QSHARE_EXPIRY_DATE));
        } else {
            QName type = this.nodeService.getType(nodeRef);
            boolean sharable = this.isSharable(type);
            metadata.put("sharable", sharable);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("item", metadata);
        return model;
    }

    @Override
    public Pair<String, NodeRef> getTenantNodeRefFromSharedId(final String sharedId) {
        NodeRef nodeRef = (NodeRef)TenantUtil.runAsDefaultTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return (NodeRef)QuickShareServiceImpl.this.attributeService.getAttribute(new Serializable[]{QuickShareServiceImpl.ATTR_KEY_SHAREDIDS_ROOT, sharedId});
            }
        });
        if (nodeRef == null) {
            String query = "+TYPE:\"cm:content\" AND +ASPECT:\"qshare:shared\" AND =qshare:sharedId:\"" + sharedId + "\"";
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("fts-alfresco");
            sp.setQuery(query);
            sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            List nodeRefs = null;
            try (ResultSet results = null;){
                try {
                    results = this.searchService.query(sp);
                    nodeRefs = results.getNodeRefs();
                }
                catch (Exception exception) {
                    throw new InvalidSharedIdException(sharedId);
                }
            }
            if (nodeRefs.size() != 1) {
                throw new InvalidSharedIdException(sharedId);
            }
            nodeRef = this.tenantService.getName((NodeRef)nodeRefs.get(0));
        }
        String tenantDomain = this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier());
        return new Pair((Object)tenantDomain, (Object)this.tenantService.getBaseName(nodeRef));
    }

    @Override
    public Map<String, Object> getMetaData(String sharedId) {
        this.checkEnabled();
        Pair<String, NodeRef> pair = this.getTenantNodeRefFromSharedId(sharedId);
        String tenantDomain = (String)pair.getFirst();
        final NodeRef nodeRef = (NodeRef)pair.getSecond();
        Map model = (Map)TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                QuickShareServiceImpl.this.checkQuickShareNode(nodeRef);
                return QuickShareServiceImpl.this.getMetaData(nodeRef);
            }
        }, (String)tenantDomain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("QuickShare - retrieved metadata: " + sharedId + " [" + String.valueOf(nodeRef) + "][" + String.valueOf(model) + "]"));
        }
        return model;
    }

    private void checkQuickShareNode(NodeRef nodeRef) {
        if (!this.nodeService.getAspects(nodeRef).contains(QuickShareModel.ASPECT_QSHARE)) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    @Override
    public void beforeDeleteNode(final NodeRef beforeDeleteNodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                block6: {
                    String sharedId = (String)((Object)QuickShareServiceImpl.this.nodeService.getProperty(beforeDeleteNodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                    if (sharedId != null) {
                        try {
                            Pair<String, NodeRef> pair = QuickShareServiceImpl.this.getTenantNodeRefFromSharedId(sharedId);
                            String cfr_ignored_0 = (String)pair.getFirst();
                            NodeRef nodeRef = (NodeRef)pair.getSecond();
                            if (!nodeRef.equals((Object)beforeDeleteNodeRef)) break block6;
                            QuickShareServiceImpl.this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                            try {
                                QuickShareServiceImpl.this.nodeService.removeAspect(nodeRef, QuickShareModel.ASPECT_QSHARE);
                            }
                            finally {
                                QuickShareServiceImpl.this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                            }
                            QuickShareServiceImpl.this.removeSharedId(sharedId);
                        }
                        catch (InvalidSharedIdException invalidSharedIdException) {
                            logger.warn((Object)("Couldn't find shareId, " + sharedId + ", attributes for node " + String.valueOf(beforeDeleteNodeRef)));
                        }
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void onRestoreNode(ChildAssociationRef childAssocRef) {
        final NodeRef childNodeRef = childAssocRef.getChildRef();
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (QuickShareServiceImpl.this.nodeService.hasAspect(childNodeRef, QuickShareModel.ASPECT_QSHARE)) {
                    QuickShareServiceImpl.this.behaviourFilter.disableBehaviour(childNodeRef, ContentModel.ASPECT_AUDITABLE);
                    try {
                        QuickShareServiceImpl.this.nodeService.removeAspect(childNodeRef, QuickShareModel.ASPECT_QSHARE);
                    }
                    finally {
                        QuickShareServiceImpl.this.behaviourFilter.enableBehaviour(childNodeRef, ContentModel.ASPECT_AUDITABLE);
                    }
                }
                return null;
            }
        });
    }

    private void removeSharedId(final String sharedId) {
        TenantUtil.runAsDefaultTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                QuickShareServiceImpl.this.attributeService.removeAttribute(new Serializable[]{QuickShareServiceImpl.ATTR_KEY_SHAREDIDS_ROOT, sharedId});
                return null;
            }
        });
        try {
            NodeRef expiryActionNodeRef = this.getQuickShareLinkExpiryActionNode(sharedId);
            if (expiryActionNodeRef != null) {
                this.deleteQuickShareLinkExpiryAction(expiryActionNodeRef);
            }
        }
        catch (Exception exception) {
            throw new QuickShareLinkExpiryActionException("Couldn't delete the quick share link expiry action for the sharedId:" + sharedId);
        }
    }

    @Override
    public void unshareContent(final String sharedId) {
        Pair<String, NodeRef> pair = this.getTenantNodeRefFromSharedId(sharedId);
        String tenantDomain = (String)pair.getFirst();
        final NodeRef nodeRef = (NodeRef)pair.getSecond();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                QName typeQName = QuickShareServiceImpl.this.nodeService.getType(nodeRef);
                if (!QuickShareServiceImpl.this.isSharable(typeQName)) {
                    throw new InvalidNodeRefException(nodeRef);
                }
                String nodeSharedId = (String)((Object)QuickShareServiceImpl.this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                if (!EqualsHelper.nullSafeEquals((Object)nodeSharedId, (Object)sharedId)) {
                    logger.warn((Object)("SharedId mismatch: expected=" + sharedId + ",actual=" + nodeSharedId));
                }
                QuickShareServiceImpl.this.behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                try {
                    QuickShareServiceImpl.this.nodeService.removeAspect(nodeRef, QuickShareModel.ASPECT_QSHARE);
                }
                finally {
                    QuickShareServiceImpl.this.behaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                }
                return null;
            }
        }, (String)tenantDomain);
        this.removeSharedId(sharedId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("QuickShare - unshared content: " + sharedId + " [" + String.valueOf(nodeRef) + "]"));
        }
    }

    private boolean isSharable(QName type) {
        return type.equals((Object)ContentModel.TYPE_CONTENT) || this.dictionaryService.isSubClass(type, ContentModel.TYPE_CONTENT);
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    @Override
    public boolean canRead(String sharedId) {
        Pair<String, NodeRef> pair = this.getTenantNodeRefFromSharedId(sharedId);
        String tenantDomain = (String)pair.getFirst();
        final NodeRef nodeRef = (NodeRef)pair.getSecond();
        return (Boolean)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                try {
                    QuickShareServiceImpl.this.checkQuickShareNode(nodeRef);
                    if (QuickShareServiceImpl.this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.ALLOWED) {
                        return true;
                    }
                    return false;
                }
                catch (AccessDeniedException accessDeniedException) {
                    return false;
                }
            }
        }, (String)tenantDomain);
    }

    @Override
    public void sendEmailNotification(QuickShareEmailRequest emailRequest) {
        ParameterCheck.mandatory((String)"emailRequest", (Object)emailRequest);
        emailRequest.validate();
        ClientAppConfig.ClientApp clientApp = this.clientAppConfig.getClient(emailRequest.getClient());
        if (clientApp == null) {
            throw new ClientAppNotFoundException("Client was not found [" + emailRequest.getClient() + "]");
        }
        String authenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        NodeRef senderNodeRef = this.personService.getPerson(authenticatedUser, false);
        Map senderProps = this.nodeService.getProperties(senderNodeRef);
        String senderFirstName = (String)senderProps.get(ContentModel.PROP_FIRSTNAME);
        String senderLastName = (String)senderProps.get(ContentModel.PROP_LASTNAME);
        String senderFullName = ((String)(senderFirstName != null ? senderFirstName + " " : "") + (senderLastName != null ? senderLastName : "")).trim();
        HashMap<String, Object> templateModel = new HashMap<String, Object>(6);
        templateModel.put(FTL_SENDER_FIRST_NAME, senderFirstName);
        templateModel.put(FTL_SENDER_LAST_NAME, senderLastName);
        String sharedNodeUrl = this.getUrl(clientApp.getProperty(CONFIG_SHARED_LINK_BASE_URL), CONFIG_SHARED_LINK_BASE_URL) + "/" + emailRequest.getSharedId();
        templateModel.put(FTL_SHARED_NODE_URL, sharedNodeUrl);
        templateModel.put(FTL_SHARED_NODE_NAME, emailRequest.getSharedNodeName());
        templateModel.put(FTL_SENDER_MESSAGE, emailRequest.getSenderMessage());
        String templateAssetsUrl = this.getUrl(clientApp.getTemplateAssetsUrl(), "templateAssetsUrl");
        templateModel.put(FTL_TEMPLATE_ASSETS_URL, templateAssetsUrl);
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.put("from", this.defaultEmailSender);
        actionParams.put("fromPersonalName", senderFullName);
        actionParams.put("subject", DEFAULT_EMAIL_SUBJECT);
        actionParams.put("subjectParams", new Object[]{senderFirstName, senderLastName, emailRequest.getSharedNodeName()});
        actionParams.put("ignore_send_failure", emailRequest.isIgnoreSendFailure());
        String templatePath = this.emailHelper.getEmailTemplate(clientApp.getName(), this.getSharedLinkEmailTemplatePath(clientApp), EMAIL_TEMPLATE_REF);
        actionParams.put("template", templatePath);
        actionParams.put("template_model", templateModel);
        actionParams.put("locale", this.getDefaultIfNull(this.emailHelper.getUserLocaleOrDefault(authenticatedUser), emailRequest.getLocale()));
        for (String to : emailRequest.getToEmails()) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>(actionParams);
            params.put("to", (Serializable)((Object)to));
            Action mailAction = this.actionService.createAction("mail", params);
            this.actionService.executeAction(mailAction, null, false, true);
        }
    }

    protected String getSharedLinkEmailTemplatePath(ClientAppConfig.ClientApp clientApp) {
        return clientApp.getProperty("sharedLinkTemplatePath");
    }

    @Override
    public boolean canDeleteSharedLink(NodeRef nodeRef, String sharedByUserId) {
        boolean canDeleteSharedLink = false;
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String siteName = this.getSiteName(nodeRef);
        boolean isSharedByCurrentUser = currentUser.equals(sharedByUserId);
        if (siteName != null) {
            String role = this.siteService.getMembersRole(siteName, currentUser);
            if (isSharedByCurrentUser || role != null && (role.equals("SiteManager") || role.equals("SiteCollaborator")) || this.authorityService.isAdminAuthority(currentUser)) {
                canDeleteSharedLink = true;
            }
        } else if (isSharedByCurrentUser || this.authorityService.isAdminAuthority(currentUser)) {
            canDeleteSharedLink = true;
        }
        return canDeleteSharedLink;
    }

    @Override
    public boolean isQuickShareEnabled() {
        return this.enabled;
    }

    private String getSiteName(NodeRef nodeRef) {
        NodeRef parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        while (parent != null && !this.nodeService.getType(parent).equals((Object)SiteModel.TYPE_SITE)) {
            if (this.permissionService.hasReadPermission(parent) != AccessStatus.ALLOWED) {
                return null;
            }
            String cfr_ignored_0 = (String)((Object)this.nodeService.getProperty(parent, ContentModel.PROP_NAME));
            if (this.nodeService.getPrimaryParent(nodeRef) == null) continue;
            parent = this.nodeService.getPrimaryParent(parent).getParentRef();
        }
        if (parent == null) {
            return null;
        }
        return this.nodeService.getProperty(parent, ContentModel.PROP_NAME).toString();
    }

    private String getUrl(String url, String propName) {
        if (url == null) {
            logger.warn((Object)("URL for the property [" + propName + "] is not configured."));
            return "";
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return UrlUtil.replaceShareUrlPlaceholder(url, this.sysAdminParams);
    }

    private <T> T getDefaultIfNull(T defaultValue, T newValue) {
        return newValue == null ? defaultValue : newValue;
    }

    protected void saveSharedLinkExpiryAction(String sharedId, Date expiryDate) {
        NodeRef expiryActionNodeRef;
        ParameterCheck.mandatory((String)"expiryDate", (Object)expiryDate);
        this.checkExpiryDate(expiryDate);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating shared link expiry action for the sharedId:" + sharedId));
        }
        if ((expiryActionNodeRef = this.getQuickShareLinkExpiryActionNode(sharedId)) != null) {
            this.deleteQuickShareLinkExpiryAction(expiryActionNodeRef);
        }
        QuickShareLinkExpiryActionImpl expiryAction = new QuickShareLinkExpiryActionImpl(UUID.randomUUID().toString(), sharedId, "QuickShare link expiry action");
        ScheduledPersistedAction schedule = this.scheduledPersistedActionService.createSchedule(expiryAction);
        expiryAction.setSchedule(schedule);
        expiryAction.setScheduleStart(expiryDate);
        try {
            TenantUtil.runAsDefaultTenant(() -> {
                this.quickShareLinkExpiryActionPersister.saveQuickShareLinkExpiryAction(expiryAction);
                this.scheduledPersistedActionService.saveSchedule(schedule);
                return null;
            });
        }
        catch (Exception ex) {
            throw new QuickShareLinkExpiryActionException("Couldn't create quick share link expiry action.", ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Quick share link expiry action is created for sharedId[" + sharedId + "] and it's scheduled to be executed on: " + String.valueOf(expiryDate)));
        }
    }

    @Override
    public void deleteQuickShareLinkExpiryAction(QuickShareLinkExpiryAction linkExpiryAction) {
        ParameterCheck.mandatory((String)"linkExpiryAction", (Object)linkExpiryAction);
        NodeRef nodeRef = null;
        try {
            Pair<String, NodeRef> pair = this.getTenantNodeRefFromSharedId(linkExpiryAction.getSharedId());
            nodeRef = (NodeRef)pair.getSecond();
        }
        catch (InvalidSharedIdException invalidSharedIdException) {}
        NodeRef sharedNodeRef = nodeRef;
        TenantUtil.runAsSystemTenant(() -> {
            this.deleteQuickShareLinkExpiryActionImpl(linkExpiryAction);
            if (sharedNodeRef != null && this.nodeService.getProperty(sharedNodeRef, QuickShareModel.PROP_QSHARE_EXPIRY_DATE) != null) {
                this.behaviourFilter.disableBehaviour(sharedNodeRef, ContentModel.ASPECT_AUDITABLE);
                try {
                    this.nodeService.removeProperty(sharedNodeRef, QuickShareModel.PROP_QSHARE_EXPIRY_DATE);
                }
                finally {
                    this.behaviourFilter.enableBehaviour(sharedNodeRef, ContentModel.ASPECT_AUDITABLE);
                }
            }
            return null;
        }, (String)TenantUtil.getCurrentDomain());
    }

    protected void deleteQuickShareLinkExpiryAction(NodeRef linkExpiryActionNodeRef) {
        TenantUtil.runAsDefaultTenant(() -> {
            QuickShareLinkExpiryAction linkExpiryAction = this.quickShareLinkExpiryActionPersister.loadQuickShareLinkExpiryAction(linkExpiryActionNodeRef);
            this.deleteQuickShareLinkExpiryActionImpl(linkExpiryAction);
            return null;
        });
    }

    private void deleteQuickShareLinkExpiryActionImpl(QuickShareLinkExpiryAction linkExpiryAction) {
        this.attachSchedule(linkExpiryAction);
        if (linkExpiryAction.getSchedule() != null) {
            this.scheduledPersistedActionService.deleteSchedule(linkExpiryAction.getSchedule());
        }
        this.quickShareLinkExpiryActionPersister.deleteQuickShareLinkExpiryAction(linkExpiryAction);
    }

    private QuickShareLinkExpiryAction attachSchedule(QuickShareLinkExpiryAction quickShareLinkExpiryAction) {
        if (quickShareLinkExpiryAction.getSchedule() == null) {
            ScheduledPersistedAction schedule = this.scheduledPersistedActionService.getSchedule(quickShareLinkExpiryAction);
            quickShareLinkExpiryAction.setSchedule(schedule);
        }
        return quickShareLinkExpiryAction;
    }

    private NodeRef getQuickShareLinkExpiryActionNode(String sharedId) {
        QName expiryActionQName = QuickShareLinkExpiryActionImpl.createQName(sharedId);
        return (NodeRef)TenantUtil.runAsDefaultTenant(() -> this.quickShareLinkExpiryActionPersister.getQuickShareLinkExpiryActionNode(expiryActionQName));
    }

    private void checkExpiryDate(Date expiryDate) {
        DateTime now = DateTime.now();
        if (now.isAfter(expiryDate.getTime())) {
            throw new QuickShareLinkExpiryActionException.InvalidExpiryDateException("Invalid expiry date. Expiry date can't be in the past.");
        }
        if (this.expiryDatePeriod.getDuration(now, new DateTime((Object)expiryDate)) < 1) {
            throw new QuickShareLinkExpiryActionException.InvalidExpiryDateException("Invalid expiry date. Expiry date can't be less then 1 " + this.expiryDatePeriod.getMessage() + ".");
        }
    }

    private static enum ExpiryDatePeriod {
        DAYS{

            @Override
            int getDuration(DateTime now, DateTime expiryDate) {
                Interval interval = new Interval((ReadableInstant)now.withSecondOfMinute(0).withMillisOfSecond(0), (ReadableInstant)expiryDate);
                return interval.toPeriod(PeriodType.days()).getDays();
            }

            @Override
            String getMessage() {
                return "day (24 hours)";
            }
        }
        ,
        HOURS{

            @Override
            int getDuration(DateTime now, DateTime expiryDate) {
                Interval interval = new Interval((ReadableInstant)now.withSecondOfMinute(0).withMillisOfSecond(0), (ReadableInstant)expiryDate);
                return interval.toPeriod(PeriodType.hours()).getHours();
            }

            @Override
            String getMessage() {
                return "hour";
            }
        }
        ,
        MINUTES{

            @Override
            public int getDuration(DateTime now, DateTime expiryDate) {
                Interval interval = new Interval((ReadableInstant)now.withMillisOfSecond(0), (ReadableInstant)expiryDate);
                return interval.toPeriod(PeriodType.minutes()).getMinutes();
            }

            @Override
            String getMessage() {
                return "minute";
            }
        };


        abstract int getDuration(DateTime var1, DateTime var2);

        abstract String getMessage();
    }

    public static class QuickShareEmailRequest {
        private String client;
        private Locale locale;
        private Set<String> toEmails;
        private String sharedId;
        private String sharedNodeName;
        private String senderMessage;
        private boolean ignoreSendFailure = false;

        public void validate() {
            ParameterCheck.mandatoryCollection((String)"toEmails", this.toEmails);
            ParameterCheck.mandatoryString((String)"sharedId", (String)this.sharedId);
            ParameterCheck.mandatoryString((String)"sharedNodeName", (String)this.sharedNodeName);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public Set<String> getToEmails() {
            return this.toEmails;
        }

        public void setToEmails(Collection<String> toEmails) {
            if (toEmails != null) {
                this.toEmails = Collections.unmodifiableSet(new HashSet<String>(toEmails));
            }
        }

        public String getClient() {
            return this.client;
        }

        public QuickShareEmailRequest setClient(String client) {
            this.client = client;
            return this;
        }

        public String getSharedId() {
            return this.sharedId;
        }

        public QuickShareEmailRequest setSharedId(String sharedId) {
            this.sharedId = sharedId;
            return this;
        }

        public String getSharedNodeName() {
            return this.sharedNodeName;
        }

        public void setSharedNodeName(String sharedNodeName) {
            this.sharedNodeName = sharedNodeName;
        }

        public String getSenderMessage() {
            return this.senderMessage;
        }

        public void setSenderMessage(String senderMessage) {
            this.senderMessage = senderMessage;
        }

        public boolean isIgnoreSendFailure() {
            return this.ignoreSendFailure;
        }

        public void setIgnoreSendFailure(Boolean ignoreSendFailure) {
            if (ignoreSendFailure != null) {
                this.ignoreSendFailure = ignoreSendFailure;
            }
        }
    }
}

