/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public class PlainStringifierTest
extends TestCase {
    @Test
    public void testEncode1() throws Exception {
        Reference r = new Reference(Encodings.ZERO.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"));
        PlainStringifierTest.assertEquals((String)"virtual:classpath:/org/alfresco/", (String)r.encode(Encodings.PLAIN.encoding));
    }

    @Test
    public void testStringifyReference() throws Exception {
        new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/org/alfresco/"));
    }

    public void testStringifyRepositoryNodeRef() throws Exception {
        RepositoryResource rr1 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444")));
        Reference r = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)rr1);
        PlainStringifierTest.assertEquals((String)"virtual:repository:node:workspace:SpacesStore:0029-222-333-444", (String)r.encode(Encodings.PLAIN.encoding));
    }

    public void testStringifyRepositoryPath() throws Exception {
        RepositoryResource rr2 = new RepositoryResource((RepositoryLocation)new RepositoryPath("/Data Dictionary/Virtual Folders/claim.json"));
        Reference r = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)rr2);
        PlainStringifierTest.assertEquals((String)"virtual:repository:path:/Data Dictionary/Virtual Folders/claim.json", (String)r.encode(Encodings.PLAIN.encoding));
    }
}

