/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.UnsupportedEncodingException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.httpclient.RequestHeadersHttpClient;
import org.alfresco.repo.search.impl.solr.ExplicitSolrStoreMappingWrapper;
import org.alfresco.repo.search.impl.solr.SolrStoreMapping;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.beans.factory.BeanFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class SolrStoreMappingWrapperTest {
    SolrStoreMapping mapping;
    ExplicitSolrStoreMappingWrapper wrapper;
    @Mock
    HttpClientFactory httpClientFactory;
    @Mock
    RequestHeadersHttpClient httpClientCommon;
    @Mock
    RequestHeadersHttpClient httpClient1;
    @Mock
    RequestHeadersHttpClient httpClient2;
    @Mock
    RequestHeadersHttpClient httpClient3;
    @Mock
    RequestHeadersHttpClient httpClient4;
    @Mock
    RequestHeadersHttpClient httpClient5;
    @Mock
    RequestHeadersHttpClient httpClient6;
    @Mock
    RequestHeadersHttpClient httpClient7;
    @Mock
    RequestHeadersHttpClient httpClient8;
    @Mock
    RequestHeadersHttpClient httpClient9;
    @Mock
    HostConfiguration hostConfigurationCommon;
    @Mock
    HostConfiguration hostConfiguration1;
    @Mock
    HostConfiguration hostConfiguration2;
    @Mock
    HostConfiguration hostConfiguration3;
    @Mock
    HostConfiguration hostConfiguration4;
    @Mock
    HostConfiguration hostConfiguration5;
    @Mock
    HostConfiguration hostConfiguration6;
    @Mock
    HostConfiguration hostConfiguration7;
    @Mock
    HostConfiguration hostConfiguration8;
    @Mock
    HostConfiguration hostConfiguration9;
    @Mock
    Protocol protocol;
    private SolrStoreMapping unsharded;
    private ExplicitSolrStoreMappingWrapper unshardedWrapper;
    @Mock
    private BeanFactory beanFactory;

    @Before
    public void init() {
        ((Protocol)Mockito.doReturn((Object)"https").when((Object)this.protocol)).getScheme();
        ((HostConfiguration)Mockito.doReturn((Object)"common").when((Object)this.hostConfigurationCommon)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)999).when((Object)this.hostConfigurationCommon)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfigurationCommon)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"host").when((Object)this.hostConfiguration1)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)999).when((Object)this.hostConfiguration1)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)"common").when((Object)this.hostConfiguration2)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)123).when((Object)this.hostConfiguration2)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration2)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"port").when((Object)this.hostConfiguration3)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)234).when((Object)this.hostConfiguration3)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration3)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"full").when((Object)this.hostConfiguration4)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)345).when((Object)this.hostConfiguration4)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration4)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"common").when((Object)this.hostConfiguration5)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)456).when((Object)this.hostConfiguration5)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration5)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"base").when((Object)this.hostConfiguration6)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)999).when((Object)this.hostConfiguration6)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration6)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"common").when((Object)this.hostConfiguration7)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)567).when((Object)this.hostConfiguration7)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration7)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"common").when((Object)this.hostConfiguration8)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)678).when((Object)this.hostConfiguration8)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration8)).getProtocol();
        ((HostConfiguration)Mockito.doReturn((Object)"common").when((Object)this.hostConfiguration9)).getHost();
        ((HostConfiguration)Mockito.doReturn((Object)789).when((Object)this.hostConfiguration9)).getPort();
        ((HostConfiguration)Mockito.doReturn((Object)this.protocol).when((Object)this.hostConfiguration9)).getProtocol();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfigurationCommon).when((Object)this.httpClientCommon)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration1).when((Object)this.httpClient1)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration2).when((Object)this.httpClient2)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration3).when((Object)this.httpClient3)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration4).when((Object)this.httpClient4)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration5).when((Object)this.httpClient5)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration6).when((Object)this.httpClient6)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration7).when((Object)this.httpClient7)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration8).when((Object)this.httpClient8)).getHostConfiguration();
        ((RequestHeadersHttpClient)Mockito.doReturn((Object)this.hostConfiguration9).when((Object)this.httpClient9)).getHostConfiguration();
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClientCommon).when((Object)this.httpClientFactory)).getHttpClient();
        ((HttpClientFactory)Mockito.doReturn((Object)"common").when((Object)this.httpClientFactory)).getHost();
        ((HttpClientFactory)Mockito.doReturn((Object)999).when((Object)this.httpClientFactory)).getPort();
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClientCommon).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"common"), ArgumentMatchers.eq((int)999));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient1).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"host"), ArgumentMatchers.eq((int)999));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient2).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"common"), ArgumentMatchers.eq((int)123));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient3).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"port"), ArgumentMatchers.eq((int)234));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient4).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"full"), ArgumentMatchers.eq((int)345));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient5).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"common"), ArgumentMatchers.eq((int)456));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient6).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"base"), ArgumentMatchers.eq((int)999));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient7).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"common"), ArgumentMatchers.eq((int)567));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient8).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"common"), ArgumentMatchers.eq((int)678));
        ((HttpClientFactory)Mockito.doReturn((Object)this.httpClient9).when((Object)this.httpClientFactory)).getHttpClient((String)ArgumentMatchers.eq((Object)"common"), ArgumentMatchers.eq((int)789));
        ((BeanFactory)Mockito.doReturn((Object)this.httpClientFactory).when((Object)this.beanFactory)).getBean((String)ArgumentMatchers.eq((Object)"httpClientFactory"));
        this.mapping = new SolrStoreMapping();
        this.mapping.setBaseUrl("/solr4");
        this.mapping.setHttpClientFactory("httpClientFactory");
        this.mapping.setIdentifier(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getIdentifier());
        this.mapping.setNodeString("host, 123, /woof, port:234, full:345/meep/sheep, 456/cabbage, base/url,,:,:/,:567,:678/,789/more,/");
        this.mapping.setNumShards(24);
        this.mapping.setProtocol(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getProtocol());
        this.mapping.setReplicationFactor(3);
        this.wrapper = new ExplicitSolrStoreMappingWrapper(this.mapping, this.beanFactory);
        this.unsharded = new SolrStoreMapping();
        this.unsharded.setBaseUrl("/solr4");
        this.unsharded.setHttpClientFactory("httpClientFactory");
        this.unsharded.setIdentifier(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getIdentifier());
        this.unsharded.setProtocol(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getProtocol());
        this.unshardedWrapper = new ExplicitSolrStoreMappingWrapper(this.unsharded, this.beanFactory);
    }

    @Test
    public void testBasics() {
        Assert.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getIdentifier(), (Object)this.mapping.getIdentifier());
        Assert.assertEquals((long)24L, (long)this.mapping.getNumShards());
        Assert.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getProtocol(), (Object)this.mapping.getProtocol());
        Assert.assertEquals((long)3L, (long)this.mapping.getReplicationFactor());
        Assert.assertEquals((Object)StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, (Object)this.mapping.getStoreRef());
        Assert.assertEquals((long)12L, (long)this.wrapper.getNodeCount());
        Assert.assertTrue((boolean)this.wrapper.isSharded());
    }

    @Test
    public void testShards() {
        String shards = this.wrapper.getShards();
        Assert.assertNotNull((Object)shards);
        Assert.assertTrue((shards.length() > 0 ? 1 : 0) != 0);
        String[] fragments = shards.split(",");
        Assert.assertEquals((long)this.mapping.getNumShards(), (long)fragments.length);
    }

    @Test
    public void testSingleShard() throws UnsupportedEncodingException {
        URLCodec encoder = new URLCodec();
        String shards = this.unshardedWrapper.getShards();
        Assert.assertNotNull((Object)shards);
        Assert.assertEquals((Object)(encoder.encode("https://", "UTF-8") + "common:999" + encoder.encode("/solr4", "UTF-8")), (Object)shards);
    }

    @Test
    public void testDistribution() {
        Pair distributor = this.wrapper.getHttpClientAndBaseUrl();
        Assert.assertNotNull((Object)distributor);
        Assert.assertEquals((Object)"/woof-14", (Object)distributor.getSecond());
        Assert.assertEquals((Object)"common", (Object)((HttpClient)distributor.getFirst()).getHostConfiguration().getHost());
        Assert.assertEquals((long)999L, (long)((HttpClient)distributor.getFirst()).getHostConfiguration().getPort());
    }

    @Test
    public void testUnsharded() {
        Assert.assertTrue((!this.unshardedWrapper.isSharded() ? 1 : 0) != 0);
        Pair distributor = this.unshardedWrapper.getHttpClientAndBaseUrl();
        Assert.assertNotNull((Object)distributor);
        Assert.assertEquals((Object)"/solr4", (Object)distributor.getSecond());
        Assert.assertEquals((Object)"common", (Object)((HttpClient)distributor.getFirst()).getHostConfiguration().getHost());
        Assert.assertEquals((long)999L, (long)((HttpClient)distributor.getFirst()).getHostConfiguration().getPort());
    }
}

