/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.apache.chemistry.opencmis.commons.enums.Action;

public class PermissionActionEvaluator
extends AbstractActionEvaluator {
    private String[] permissions;
    private PermissionService permissionService;

    protected PermissionActionEvaluator(ServiceRegistry serviceRegistry, Action action, String ... permission) {
        super(serviceRegistry, action);
        this.permissions = permission;
        this.permissionService = serviceRegistry.getPermissionService();
    }

    public boolean isAllowed(CMISNodeInfo nodeInfo) {
        String[] stringArray = this.permissions;
        int n = this.permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String permission = stringArray[n2];
            if (this.permissionService.hasPermission(nodeInfo.getNodeRef(), permission) == AccessStatus.DENIED) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PermissionActionEvaluator[action=").append(this.getAction());
        builder.append(", permissions=");
        String[] stringArray = this.permissions;
        int n = this.permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String permission = stringArray[n2];
            builder.append(permission).append(",");
            ++n2;
        }
        builder.append("]");
        return builder.toString();
    }
}

