/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.tenant;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.domain.tenant.TenantUpdateEntity;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class TenantAdminDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private TenantAdminDAO tenantAdminDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.tenantAdminDAO = (TenantAdminDAO)this.ctx.getBean("tenantAdminDAO");
    }

    private TenantEntity createTenant(final String tenantDomain, final boolean enabled) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity>(){

            public TenantEntity execute() throws Throwable {
                TenantEntity tenantEntity = new TenantEntity();
                tenantEntity.setTenantDomain(tenantDomain);
                tenantEntity.setEnabled(enabled);
                return TenantAdminDAOTest.this.tenantAdminDAO.createTenant(tenantEntity);
            }
        };
        return (TenantEntity)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false);
    }

    private void deleteTenant(final String tenantDomain) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TenantAdminDAOTest.this.tenantAdminDAO.deleteTenant(tenantDomain);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false);
    }

    private void updateTenant(final TenantUpdateEntity tenantUpdateEntity) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TenantAdminDAOTest.this.tenantAdminDAO.updateTenant(tenantUpdateEntity);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false);
    }

    private TenantEntity getTenant(final String tenantDomain) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<TenantEntity>(){

            public TenantEntity execute() throws Throwable {
                return TenantAdminDAOTest.this.tenantAdminDAO.getTenant(tenantDomain);
            }
        };
        return (TenantEntity)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
    }

    private TenantUpdateEntity getTenantForUpdate(final String tenantDomain) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<TenantUpdateEntity> callback = new RetryingTransactionHelper.RetryingTransactionCallback<TenantUpdateEntity>(){

            public TenantUpdateEntity execute() throws Throwable {
                return TenantAdminDAOTest.this.tenantAdminDAO.getTenantForUpdate(tenantDomain);
            }
        };
        return (TenantUpdateEntity)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
    }

    private List<TenantEntity> listTenants(final boolean enabledOnly) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<List<TenantEntity>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<List<TenantEntity>>(){

            public List<TenantEntity> execute() throws Throwable {
                return TenantAdminDAOTest.this.tenantAdminDAO.listTenants(enabledOnly);
            }
        };
        return (List)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
    }

    public void testCreateAndDeleteTenant() throws Exception {
        String tenantDomain = this.getName() + "-" + System.currentTimeMillis();
        TenantEntity tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)tenantEntity);
        TenantEntity newTenantEntity = new TenantEntity();
        newTenantEntity.setTenantDomain(tenantDomain);
        newTenantEntity.setEnabled(false);
        TenantEntity createTenantEntity = this.createTenant(tenantDomain, false);
        TenantAdminDAOTest.assertNotNull((Object)createTenantEntity);
        tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertEquals((Object)createTenantEntity, (Object)tenantEntity);
        this.deleteTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)this.getTenant(tenantDomain));
    }

    public void testCreateTenantWithRollback() throws Exception {
        final String tenantDomain = this.getName() + "-" + System.currentTimeMillis();
        TenantEntity newTenantEntity = new TenantEntity();
        newTenantEntity.setTenantDomain(tenantDomain);
        newTenantEntity.setEnabled(false);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TenantAdminDAOTest.this.createTenant(tenantDomain, false);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            TenantAdminDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {}
        TenantAdminDAOTest.assertNull((Object)this.getTenant(tenantDomain));
    }

    public void testUpdateTenant() throws Exception {
        String tenantDomain = this.getName() + "-" + System.currentTimeMillis();
        TenantEntity tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)tenantEntity);
        TenantEntity createTenantEntity = this.createTenant(tenantDomain, false);
        TenantAdminDAOTest.assertNotNull((Object)createTenantEntity);
        TenantAdminDAOTest.assertFalse((boolean)createTenantEntity.getEnabled());
        TenantUpdateEntity tenantUpdateEntity = this.getTenantForUpdate(tenantDomain);
        TenantAdminDAOTest.assertEquals((Object)createTenantEntity, (Object)tenantUpdateEntity);
        TenantAdminDAOTest.assertFalse((boolean)tenantUpdateEntity.getEnabled());
        TenantAdminDAOTest.assertEquals((String)createTenantEntity.getTenantDomain(), (String)tenantUpdateEntity.getTenantDomain());
        TenantAdminDAOTest.assertEquals((Object)createTenantEntity.getEnabled(), (Object)tenantUpdateEntity.getEnabled());
        TenantAdminDAOTest.assertEquals((String)createTenantEntity.getTenantName(), (String)tenantUpdateEntity.getTenantName());
        TenantAdminDAOTest.assertEquals((String)createTenantEntity.getContentRoot(), (String)tenantUpdateEntity.getContentRoot());
        TenantAdminDAOTest.assertEquals((String)createTenantEntity.getDbUrl(), (String)tenantUpdateEntity.getDbUrl());
        tenantUpdateEntity.setEnabled(true);
        this.updateTenant(tenantUpdateEntity);
        tenantEntity = this.getTenant(tenantDomain);
        TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
        TenantAdminDAOTest.assertTrue((boolean)tenantEntity.getEnabled());
        TenantAdminDAOTest.assertEquals((String)tenantEntity.getTenantDomain(), (String)tenantUpdateEntity.getTenantDomain());
        TenantAdminDAOTest.assertEquals((Object)tenantEntity.getEnabled(), (Object)tenantUpdateEntity.getEnabled());
        TenantAdminDAOTest.assertEquals((String)tenantEntity.getTenantName(), (String)tenantUpdateEntity.getTenantName());
        TenantAdminDAOTest.assertEquals((String)tenantEntity.getContentRoot(), (String)tenantUpdateEntity.getContentRoot());
        TenantAdminDAOTest.assertEquals((String)tenantEntity.getDbUrl(), (String)tenantUpdateEntity.getDbUrl());
        this.deleteTenant(tenantDomain);
        TenantAdminDAOTest.assertNull((Object)this.getTenant(tenantDomain));
    }

    public void testListTenants() throws Exception {
        TenantEntity tenantEntity;
        String tenantDomain;
        String tenantDomainPrefix = this.getName() + "-" + System.currentTimeMillis();
        int beforeCnt = this.listTenants(false).size();
        int enabledCnt = this.listTenants(true).size();
        int i = 1;
        while (i <= 5) {
            tenantDomain = tenantDomainPrefix + "-" + i;
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNull((Object)tenantEntity);
            tenantEntity = this.createTenant(tenantDomain, false);
            TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
            TenantAdminDAOTest.assertEquals((int)(i + beforeCnt), (int)this.listTenants(false).size());
            TenantAdminDAOTest.assertEquals((String)"Tenant enabled/disabled count incorrect.", (int)enabledCnt, (int)this.listTenants(true).size());
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
            ++i;
        }
        i = 5;
        while (i >= 1) {
            tenantDomain = tenantDomainPrefix + "-" + i;
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNotNull((Object)tenantEntity);
            this.deleteTenant(tenantDomain);
            TenantAdminDAOTest.assertEquals((int)(i - 1 + beforeCnt), (int)this.listTenants(false).size());
            tenantEntity = this.getTenant(tenantDomain);
            TenantAdminDAOTest.assertNull((Object)tenantEntity);
            --i;
        }
    }
}

