/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator.compare;

import java.io.Serializable;
import org.alfresco.repo.action.evaluator.ComparePropertyValueEvaluator;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.PropertyValueComparator;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;

public class NumericPropertyValueComparator
implements PropertyValueComparator {
    private static final String MSGID_INVALID_OPERATION = "numeric_property_value_comparator.invalid_operation";

    @Override
    public boolean compare(Serializable propertyValue, Serializable compareValue, ComparePropertyValueOperation operation) {
        boolean result = false;
        if (operation == null) {
            operation = ComparePropertyValueOperation.EQUALS;
        }
        double property = ((Number)propertyValue).doubleValue();
        double compare = ((Number)compareValue).doubleValue();
        switch (operation) {
            case EQUALS: {
                result = property == compare;
                break;
            }
            case GREATER_THAN: {
                result = property > compare;
                break;
            }
            case GREATER_THAN_EQUAL: {
                result = property >= compare;
                break;
            }
            case LESS_THAN: {
                result = property < compare;
                break;
            }
            case LESS_THAN_EQUAL: {
                result = property <= compare;
                break;
            }
            default: {
                throw new ActionServiceException(MSGID_INVALID_OPERATION, new Object[]{operation.toString()});
            }
        }
        return result;
    }

    @Override
    public void registerComparator(ComparePropertyValueEvaluator evaluator) {
        evaluator.registerComparator(DataTypeDefinition.DOUBLE, this);
        evaluator.registerComparator(DataTypeDefinition.FLOAT, this);
        evaluator.registerComparator(DataTypeDefinition.INT, this);
        evaluator.registerComparator(DataTypeDefinition.LONG, this);
    }
}

