/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.domain.propval.PropertyTypeConverter;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyValueEntity {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Short ORDINAL_NULL = 0;
    public static final Short ORDINAL_LONG = 1;
    public static final Short ORDINAL_DOUBLE = 2;
    public static final Short ORDINAL_STRING = 3;
    public static final Short ORDINAL_SERIALIZABLE = 4;
    public static final Short ORDINAL_CONSTRUCTABLE = 5;
    public static final Short ORDINAL_ENUM = 6;
    public static final Pair<Short, Serializable> PERSISTED_TYPE_NULL = new Pair((Object)PersistedType.NULL.getOrdinalNumber(), (Object)0L);
    public static final Map<Short, PersistedType> persistedTypesByOrdinal;
    private static final Log logger;
    private Long id;
    private Long actualTypeId;
    private Short persistedType = PersistedType.NULL.getOrdinalNumber();
    private PersistedType persistedTypeEnum;
    private Long longValue = LONG_ZERO;
    private String stringValue;
    private Double doubleValue;
    private Serializable serializableValue;

    static {
        HashMap<Short, PersistedType> mapOrdinal = new HashMap<Short, PersistedType>(15);
        PersistedType[] persistedTypeArray = PersistedType.values();
        int n = persistedTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PersistedType persistedType = persistedTypeArray[n2];
            mapOrdinal.put(persistedType.getOrdinalNumber(), persistedType);
            ++n2;
        }
        persistedTypesByOrdinal = Collections.unmodifiableMap(mapOrdinal);
        logger = LogFactory.getLog(PropertyValueEntity.class);
    }

    public int hashCode() {
        return (this.actualTypeId == null ? 0 : this.actualTypeId.intValue()) + (this.longValue == null ? 0 : this.longValue.intValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PropertyValueEntity) {
            PropertyValueEntity that = (PropertyValueEntity)obj;
            return EqualsHelper.nullSafeEquals((Object)this.actualTypeId, (Object)that.actualTypeId) && EqualsHelper.nullSafeEquals((Object)this.longValue, (Object)that.longValue);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("PropertyValueEntity").append("[ ID=").append(this.id).append(", actualTypeId=").append(this.actualTypeId).append(", persistedType=").append(this.persistedType).append(", value=").append(this.longValue).append("]");
        return sb.toString();
    }

    public Serializable getValue(Class<Serializable> actualType, PropertyTypeConverter converter) {
        switch (this.persistedTypeEnum) {
            case NULL: {
                return null;
            }
            case LONG: {
                return converter.convert(actualType, this.longValue);
            }
            case DOUBLE: {
                return converter.convert(actualType, this.doubleValue);
            }
            case STRING: {
                if (this.stringValue != null && this.stringValue.equals(".empty")) {
                    return converter.convert(actualType, (Serializable)((Object)""));
                }
                return converter.convert(actualType, (Serializable)((Object)this.stringValue));
            }
            case SERIALIZABLE: {
                return converter.convert(actualType, this.serializableValue);
            }
            case CONSTRUCTABLE: {
                return converter.constructInstance(this.stringValue);
            }
            case ENUM: {
                return converter.convert(actualType, (Serializable)((Object)this.stringValue));
            }
        }
        throw new IllegalStateException("Should not be able to get through switch");
    }

    public void setValue(Serializable value, PropertyTypeConverter converter) {
        if (value == null) {
            this.persistedType = ORDINAL_NULL;
            this.persistedTypeEnum = PersistedType.NULL;
            this.longValue = LONG_ZERO;
        } else {
            this.persistedTypeEnum = converter.getPersistentType(value);
            this.persistedType = this.persistedTypeEnum.getOrdinalNumber();
            switch (this.persistedTypeEnum) {
                case LONG: {
                    this.longValue = converter.convert(Long.class, value);
                    break;
                }
                case DOUBLE: {
                    this.doubleValue = converter.convert(Double.class, value);
                    break;
                }
                case STRING: {
                    this.stringValue = converter.convert(String.class, value);
                    if (!this.stringValue.equals("")) break;
                    this.stringValue = ".empty";
                    break;
                }
                case CONSTRUCTABLE: {
                    this.stringValue = value.getClass().getName();
                    break;
                }
                case ENUM: {
                    this.stringValue = converter.convert(String.class, value);
                    break;
                }
                case SERIALIZABLE: {
                    this.serializableValue = value;
                    break;
                }
                default: {
                    throw new IllegalStateException("PropertyTypeConverter.convertToPersistentType returned illegal type:    Converter:      " + String.valueOf(converter) + "\n   Type Returned:  " + String.valueOf((Object)this.persistedTypeEnum) + "\n   From Value:     " + String.valueOf(value));
                }
            }
        }
    }

    public static PersistedType getPersistedTypeEnum(Serializable value, PropertyTypeConverter converter) {
        PersistedType persistedTypeEnum = value == null ? PersistedType.NULL : converter.getPersistentType(value);
        return persistedTypeEnum;
    }

    public PersistedType getPersistedTypeEnum() {
        return this.persistedTypeEnum;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActualTypeId() {
        return this.actualTypeId;
    }

    public void setActualTypeId(Long actualTypeId) {
        this.actualTypeId = actualTypeId;
    }

    public Short getPersistedType() {
        return this.persistedType;
    }

    public void setPersistedType(Short persistedType) {
        this.persistedType = persistedType;
        this.persistedTypeEnum = persistedTypesByOrdinal.get(persistedType);
        if (this.persistedTypeEnum == null) {
            logger.error((Object)("Persisted type '" + String.valueOf(persistedType) + "' is not recognised."));
            this.persistedTypeEnum = PersistedType.LONG;
        }
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        if (stringValue == null) {
            stringValue = "";
        }
        this.stringValue = stringValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public Serializable getSerializableValue() {
        return this.serializableValue;
    }

    public void setSerializableValue(Serializable serializableValue) {
        this.serializableValue = serializableValue;
    }

    public static enum PersistedType {
        NULL{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_NULL;
            }

            @Override
            public Class<?> getAssociatedClass() {
                throw new UnsupportedOperationException("NULL is a special case and has no associated class.");
            }
        }
        ,
        LONG{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_LONG;
            }

            @Override
            public Class<?> getAssociatedClass() {
                return Long.class;
            }
        }
        ,
        DOUBLE{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_DOUBLE;
            }

            @Override
            public Class<?> getAssociatedClass() {
                return Double.class;
            }
        }
        ,
        STRING{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_STRING;
            }

            @Override
            public Class<?> getAssociatedClass() {
                return String.class;
            }
        }
        ,
        SERIALIZABLE{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_SERIALIZABLE;
            }

            @Override
            public Class<?> getAssociatedClass() {
                return Serializable.class;
            }
        }
        ,
        CONSTRUCTABLE{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_CONSTRUCTABLE;
            }

            @Override
            public Class<?> getAssociatedClass() {
                return Class.class;
            }
        }
        ,
        ENUM{

            @Override
            public Short getOrdinalNumber() {
                return ORDINAL_ENUM;
            }

            @Override
            public Class<?> getAssociatedClass() {
                return Enum.class;
            }
        };


        public abstract Short getOrdinalNumber();

        public abstract Class<?> getAssociatedClass();
    }
}

