/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.util.Collection;
import java.util.Iterator;
import org.alfresco.service.cmr.version.Version;
import org.junit.Assert;

public final class VersionTestUtil {
    private VersionTestUtil() {
    }

    public static void assertVersions(Version expectedVersion, Version actualVersion) {
        Assert.assertEquals((String)"FrozenStateNodeRefs are not the same", (Object)expectedVersion.getFrozenStateNodeRef(), (Object)actualVersion.getFrozenStateNodeRef());
        Assert.assertEquals((String)"VersionedNodeRefs are not the same", (Object)expectedVersion.getVersionedNodeRef(), (Object)actualVersion.getVersionedNodeRef());
        Assert.assertEquals((String)"Versionlabels are not the same", (Object)expectedVersion.getVersionLabel(), (Object)actualVersion.getVersionLabel());
    }

    public static void assertVersions(Collection<Version> expected, Collection<Version> actual) {
        Assert.assertEquals((String)"Version collections are of different size", (long)expected.size(), (long)actual.size());
        Iterator<Version> expectedIt = expected.iterator();
        Iterator<Version> actualIt = actual.iterator();
        while (expectedIt.hasNext() && actualIt.hasNext()) {
            Version expectedVersion = expectedIt.next();
            Version actualVersion = actualIt.next();
            VersionTestUtil.assertVersions(expectedVersion, actualVersion);
        }
    }
}

