/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class InvitationCleanupTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT);
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT);
    public static TemporarySites TEST_SITES = new TemporarySites(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1).around((TestRule)TEST_USER2).around((TestRule)TEST_SITES);
    private static InvitationService INVITATION_SERVICE;
    private static SiteService SITE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static WorkflowService WORKFLOW_SERVICE;
    private static NodeArchiveService NODE_ARCHIVE_SERVICE;

    @BeforeClass
    public static void initStaticData() throws Exception {
        INVITATION_SERVICE = (InvitationService)APP_CONTEXT_INIT.getApplicationContext().getBean("InvitationService", InvitationService.class);
        SITE_SERVICE = (SiteService)APP_CONTEXT_INIT.getApplicationContext().getBean("SiteService", SiteService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        WORKFLOW_SERVICE = (WorkflowService)APP_CONTEXT_INIT.getApplicationContext().getBean("WorkflowService", WorkflowService.class);
        NODE_ARCHIVE_SERVICE = (NodeArchiveService)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeArchiveService", NodeArchiveService.class);
    }

    @Test
    public void pendingJoinRequestsToModeratedSitesShouldDisappearOnSiteDeletion() throws Exception {
        final String siteShortName = InvitationCleanupTest.class.getSimpleName() + "-test-site";
        TEST_SITES.createSite("sitePreset", siteShortName, "title", "description", SiteVisibility.MODERATED, TEST_USER1.getUsername());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                return (Void)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        INVITATION_SERVICE.inviteModerated("Let me in!", TEST_USER2.getUsername(), Invitation.ResourceType.WEB_SITE, siteShortName, "SiteContributor");
                        return null;
                    }
                });
            }
        }, (String)TEST_USER2.getUsername());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        InvitationCleanupTest.this.assertUserHasTasks(TEST_USER1.getUsername(), 1);
                        return null;
                    }
                });
                NodeRef archivedNodeRef = (NodeRef)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    public NodeRef execute() throws Throwable {
                        SiteInfo siteInfo = SITE_SERVICE.getSite(siteShortName);
                        SITE_SERVICE.deleteSite(siteShortName);
                        return NODE_ARCHIVE_SERVICE.getArchivedNode(siteInfo.getNodeRef());
                    }
                });
                NODE_ARCHIVE_SERVICE.purgeArchivedNode(archivedNodeRef);
                Thread.sleep(1000L);
                TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        TEST_SITES.createSite("sitePreset", siteShortName, "title", "description", SiteVisibility.MODERATED, TEST_USER1.getUsername());
                        return null;
                    }
                });
                TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        InvitationCleanupTest.this.assertUserHasTasks(TEST_USER1.getUsername(), 0);
                        return null;
                    }
                });
                return null;
            }
        }, (String)TEST_USER1.getUsername());
    }

    private List<WorkflowTask> assertUserHasTasks(String username, int number) {
        List tasks = WORKFLOW_SERVICE.getAssignedTasks(username, WorkflowTaskState.IN_PROGRESS);
        ArrayList allTasks = new ArrayList();
        allTasks.addAll(tasks);
        allTasks.addAll(WORKFLOW_SERVICE.getPooledTasks(username));
        Assert.assertEquals((String)"Wrong number of tasks assigned to user", (long)number, (long)allTasks.size());
        return tasks;
    }
}

