/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleInstallState;
import org.alfresco.util.VersionNumber;

public class ModuleDetailsImplTest
extends TestCase {
    public static Properties DEFAULT_PROPS = new Properties();

    static {
        DEFAULT_PROPS.setProperty("module.id", "org.alfresco.module.Test");
        DEFAULT_PROPS.setProperty("module.aliases", "test, Test");
        DEFAULT_PROPS.setProperty("module.title", "Test");
        DEFAULT_PROPS.setProperty("module.description", "Test description");
        DEFAULT_PROPS.setProperty("module.version", "1.0.0");
        DEFAULT_PROPS.setProperty("module.editions", "Community, Enterprise");
        DEFAULT_PROPS.setProperty("module.repo.version.min", new VersionNumber("1.2").toString());
        DEFAULT_PROPS.setProperty("module.repo.version.max", new VersionNumber("1.4.3").toString());
        DEFAULT_PROPS.setProperty("module.depends.a", "1.2.3");
        DEFAULT_PROPS.setProperty("module.depends.b", "*");
        DEFAULT_PROPS.setProperty("module.depends.c", "- 1.2");
        DEFAULT_PROPS.setProperty("module.depends.d", "1.2 -");
        DEFAULT_PROPS.setProperty("module.depends.e", "* - 1.2");
        DEFAULT_PROPS.setProperty("module.depends.f", "1.2 - *");
        DEFAULT_PROPS.setProperty("module.depends.g", "0.5, 0.6");
        DEFAULT_PROPS.setProperty("module.depends.h", "0.5 - 0.6, 0.9 - *");
        DEFAULT_PROPS.setProperty("module.installState", ModuleInstallState.INSTALLED.toString());
    }

    public void testDefaults() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_PROPS);
        new ModuleDetailsImpl(props);
    }

    public void testWriteAndReadProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_PROPS);
        ModuleDetailsImpl details = new ModuleDetailsImpl(props);
        Properties processedProperties = details.getProperties();
        ModuleDetailsImplTest.assertEquals((String)"The number of properties changed", (int)props.size(), (int)processedProperties.size());
        ModuleDetailsImplTest.assertEquals((String)"The properties are different", (Object)props, (Object)processedProperties);
    }

    public void testDependencyChecks() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_PROPS);
        ModuleDetailsImpl details = new ModuleDetailsImpl(props);
        Properties tempProperties = new Properties();
        tempProperties.setProperty("module.id", "a");
        tempProperties.setProperty("module.title", "A");
        tempProperties.setProperty("module.description", "A description");
        tempProperties.setProperty("module.version", "1.0.0");
        ModuleDetailsImpl tempDetails = new ModuleDetailsImpl(tempProperties);
        List dependencies = details.getDependencies();
        ModuleDetailsImplTest.assertEquals((String)"Incorrect number of dependencies", (int)8, (int)dependencies.size());
        for (ModuleDependency dependency : dependencies) {
            if (!dependency.getDependencyId().equals(tempDetails.getId())) continue;
            ModuleDetailsImplTest.assertFalse((String)"No match expected", (boolean)dependency.isValidDependency((ModuleDetails)tempDetails));
        }
    }

    public void testTrimming() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_PROPS);
        props.setProperty("module.installState", "    ");
        ModuleDetailsImpl details = new ModuleDetailsImpl(props);
        ModuleDetailsImplTest.assertEquals((String)"Expected the install state to be UNKNOWN", (Object)ModuleInstallState.UNKNOWN, (Object)details.getInstallState());
    }

    public void testInvalidIds() throws Exception {
        String[] invalidIds;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_PROPS);
        String[] stringArray = invalidIds = new String[]{"", " ", "$", "module$Test", "module.Test$", "org alfresco module Test"};
        int n = invalidIds.length;
        int n2 = 0;
        while (n2 < n) {
            String invalidId = stringArray[n2];
            try {
                props.setProperty("module.id", invalidId);
                new ModuleDetailsImpl(props);
                ModuleDetailsImplTest.fail((String)("Invalid ID not detected: " + invalidId));
            }
            catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
            ++n2;
        }
    }

    public void testValidIds() throws Exception {
        String[] validIds;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)DEFAULT_PROPS);
        String[] stringArray = validIds = new String[]{"abc123", " abc123 ", "a-b-c", "a.b.c", "a_b_c", "A.1.2.3"};
        int n = validIds.length;
        int n2 = 0;
        while (n2 < n) {
            String validId = stringArray[n2];
            props.setProperty("module.id", validId);
            new ModuleDetailsImpl(props);
            ++n2;
        }
    }
}

