/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.util.List;
import javax.sql.DataSource;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.dialect.PostgreSQLDialect;
import org.alfresco.repo.domain.schema.script.ScriptExecutor;
import org.alfresco.repo.domain.schema.script.ScriptExecutorImpl;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

@Category(value={LuceneTests.class})
public class ScriptExecutorImplIntegrationTest {
    private static final Log log = LogFactory.getLog(ScriptExecutorImplIntegrationTest.class);
    private static ApplicationContext ctx;
    private ScriptExecutor scriptExecutor;
    private DataSource dataSource;
    private JdbcTemplate jdbcTmpl;
    private Dialect dialect;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        String[] config = new String[]{"classpath:alfresco/application-context.xml", "classpath:scriptexec/script-exec-test.xml"};
        ctx = ApplicationContextHelper.getApplicationContext((String[])config);
    }

    @Before
    public void setUp() throws Exception {
        this.scriptExecutor = (ScriptExecutor)ctx.getBean("simpleScriptExecutor", ScriptExecutorImpl.class);
        this.dataSource = (DataSource)ctx.getBean("dataSource", DataSource.class);
        this.dialect = (Dialect)ctx.getBean("dialect", Dialect.class);
        this.jdbcTmpl = new JdbcTemplate(this.dataSource);
    }

    @Test
    public void canExecuteBasicScript() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/basic.sql");
        String select = "select textfield from alf_test_script_exec order by textfield asc";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((Object)"hello", res.get(0));
        Assert.assertEquals((Object)"world", res.get(1));
    }

    @Test
    public void canExecuteGenericDialectScript() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/generic.sql");
        String select = "select message from alf_test_script_exec_generic";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)1L, (long)res.size());
        Assert.assertEquals((Object)"generic", res.get(0));
    }

    @Test
    public void canExecuteSpecificDialectScript() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/specific.sql");
        String select = "select message from alf_test_script_exec_specific";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)1L, (long)res.size());
        if (this.dialect.getClass().equals(MySQLInnoDBDialect.class)) {
            Assert.assertEquals((Object)"mysql", res.get(0));
        } else if (this.dialect.getClass().equals(PostgreSQLDialect.class)) {
            Assert.assertEquals((Object)"postgresql", res.get(0));
        } else {
            log.warn((Object)"No suitable dialect-specific DB script for test canExecuteSpecificDialectScript()");
        }
    }

    @Test
    public void canExecuteSpecificDialectOverridingGenericScript() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/override.sql");
        String select = "select message from alf_test_script_exec_override";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)1L, (long)res.size());
        if (this.dialect.getClass().equals(MySQLInnoDBDialect.class)) {
            Assert.assertEquals((Object)"mysql", res.get(0));
        } else if (this.dialect.getClass().equals(PostgreSQLDialect.class)) {
            Assert.assertEquals((Object)"postgresql", res.get(0));
        } else {
            log.warn((Object)"No suitable dialect-specific DB script for test canExecuteSpecificDialectOverridingGenericScript()");
        }
    }

    @Test
    public void exceptionThrownWhenNoMatchingScriptFound() throws Exception {
        try {
            this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/non-existent-file.sql");
        }
        catch (AlfrescoRuntimeException e) {
            Assert.assertEquals((Object)"schema.update.err.script_not_found", (Object)e.getMsgId());
        }
    }

    @Test
    public void emptyCustomDelimiter() throws Exception {
        try {
            this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/empty-delimiter.sql");
            Assert.fail((String)"Script execution should fail.");
        }
        catch (AlfrescoRuntimeException e) {
            Assert.assertEquals((Object)"schema.update.err.delimiter_invalid", (Object)e.getMsgId());
        }
    }

    @Test
    public void wrongUsageCustomDelimiter() throws Exception {
        try {
            this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/wrong-usage-delimiter.sql");
            Assert.fail((String)"Script execution should fail.");
        }
        catch (AlfrescoRuntimeException e) {
            Assert.assertEquals((Object)"schema.update.err.delimiter_set_before_sql", (Object)e.getMsgId());
        }
    }

    @Test
    public void unterminatedCustomDelimiter() throws Exception {
        try {
            this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/unterminated-custom-delimiter.sql");
            Assert.fail((String)"Script execution should fail.");
        }
        catch (AlfrescoRuntimeException e) {
            Assert.assertEquals((Object)"schema.update.err.statement_terminator", (Object)e.getMsgId());
        }
    }

    @Test
    public void customDelimiter() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/custom-delimiter.sql");
        String select = "select message from alf_test_custom_delimiter";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertEquals((Object)"custom delimter success", res.get(0));
        Assert.assertEquals((Object)"custom delimter success again", res.get(1));
    }

    @Test
    public void deleteNonExists() throws Exception {
        this.scriptExecutor.executeScriptUrl("scriptexec/${db.script.dialect}/delete-not-exists.sql");
        String select = "select id from temp_tst_tbl_1 order by id ASC";
        List res = this.jdbcTmpl.queryForList(select, String.class);
        Assert.assertEquals((long)5L, (long)res.size());
        Assert.assertEquals((Object)"1", res.get(0));
        Assert.assertEquals((Object)"2", res.get(1));
        Assert.assertEquals((Object)"4", res.get(2));
        Assert.assertEquals((Object)"10", res.get(3));
        Assert.assertEquals((Object)"11", res.get(4));
    }
}

